/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.controller.problem.rpc.schema.types;

import java.text.SimpleDateFormat;
import java.util.List;
import org.evomaster.client.java.controller.problem.rpc.schema.params.IntParam;
import org.evomaster.client.java.controller.problem.rpc.schema.types.JavaDtoSpec;
import org.evomaster.client.java.controller.problem.rpc.schema.types.TypeSchema;

public abstract class DateType
extends TypeSchema {
    public final IntParam year;
    public final IntParam month;
    public final IntParam day;
    public final IntParam hour;
    public final IntParam minute;
    public final IntParam second;
    public final IntParam millisecond;
    public final IntParam timezone;
    private List<IntParam> dateFields;
    public static final SimpleDateFormat SIMPLE_DATE_FORMATTER = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    public static final SimpleDateFormat DATE_FORMATTER = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS ZZZZ");

    public DateType(String type, String fullTypeName, Class<?> clazz, JavaDtoSpec spec) {
        super(type, fullTypeName, clazz, spec);
        this.year = new IntParam("year", this.spec);
        this.month = new IntParam("month", this.spec);
        this.day = new IntParam("day", this.spec);
        this.hour = new IntParam("hour", this.spec);
        this.minute = new IntParam("minute", this.spec);
        this.second = new IntParam("second", this.spec);
        this.millisecond = new IntParam("millisecond", this.spec);
        this.timezone = new IntParam("timezone", this.spec);
    }

    public DateType(String type, String fullTypeName, Class<?> clazz, JavaDtoSpec spec, List<IntParam> dateFields) {
        this(type, fullTypeName, clazz, spec);
        this.setDateFields(dateFields);
    }

    protected void setDateFields(List<IntParam> fields) {
        this.dateFields = fields;
    }

    public List<IntParam> getDateFields() {
        return this.dateFields;
    }

    public abstract Object getDateInstance(List<IntParam> var1);

    public abstract List<IntParam> getIntValues(Object var1);

    public abstract long getDateLong(List<IntParam> var1);

    public abstract String getDateString(List<IntParam> var1);

    protected String formatZZZZ(int zone) {
        int value = zone;
        if (zone < 0) {
            value *= -1;
        }
        String stringValue = String.format("%04d", value);
        stringValue = zone < 0 ? "-" + stringValue : "+" + stringValue;
        return stringValue;
    }
}

