/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.controller.problem.rpc.schema.params;

import org.evomaster.client.java.controller.api.dto.problem.rpc.ParamDto;
import org.evomaster.client.java.controller.api.dto.problem.rpc.RPCSupportedDataType;
import org.evomaster.client.java.controller.problem.rpc.schema.params.PrimitiveOrWrapperParam;
import org.evomaster.client.java.controller.problem.rpc.schema.types.AccessibleSchema;
import org.evomaster.client.java.controller.problem.rpc.schema.types.JavaDtoSpec;
import org.evomaster.client.java.controller.problem.rpc.schema.types.PrimitiveOrWrapperType;

public class LongParam
extends PrimitiveOrWrapperParam<Long> {
    private static final String JAVA_PR_METHOD = "longValue";
    private static final String KOTLIN_PR_METHOD = "toLong";

    public LongParam(String name, String type, String fullTypeName, Class<?> clazz, AccessibleSchema accessibleSchema, JavaDtoSpec spec) {
        super(name, type, fullTypeName, clazz, accessibleSchema, spec);
    }

    public LongParam(String name, PrimitiveOrWrapperType type, AccessibleSchema accessibleSchema) {
        super(name, type, accessibleSchema);
    }

    @Override
    public String getValueAsJavaString(boolean isJava) {
        if (this.getValue() == null) {
            return null;
        }
        return this.getValue() + "L";
    }

    @Override
    public ParamDto getDto() {
        ParamDto dto = super.getDto();
        dto.type.type = ((PrimitiveOrWrapperType)this.getType()).isWrapper ? RPCSupportedDataType.LONG : RPCSupportedDataType.P_LONG;
        if (this.getValue() != null) {
            dto.stringValue = ((Long)this.getValue()).toString();
        }
        return dto;
    }

    public LongParam copyStructure() {
        return new LongParam(this.getName(), (PrimitiveOrWrapperType)this.getType(), this.accessibleSchema);
    }

    @Override
    public void setValueBasedOnStringValue(String stringValue) {
        try {
            if (stringValue != null) {
                this.setValue(Long.parseLong(stringValue));
            }
        }
        catch (NumberFormatException e) {
            throw new RuntimeException("ERROR: fail to convert " + stringValue + " as long value");
        }
    }

    @Override
    protected void setValueBasedOnValidInstance(Object instance) {
        this.setValue((Long)instance);
    }

    @Override
    public boolean isValidInstance(Object instance) {
        return instance instanceof Long;
    }

    @Override
    public String primitiveValueMethod(boolean isJava) {
        if (isJava) {
            return JAVA_PR_METHOD;
        }
        return KOTLIN_PR_METHOD;
    }
}

