/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.controller.problem.rpc.schema.params;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import org.evomaster.client.java.controller.api.dto.problem.rpc.ParamDto;
import org.evomaster.client.java.controller.problem.rpc.CodeJavaOrKotlinGenerator;
import org.evomaster.client.java.controller.problem.rpc.schema.params.NamedTypedValue;
import org.evomaster.client.java.controller.problem.rpc.schema.types.AccessibleSchema;
import org.evomaster.client.java.controller.problem.rpc.schema.types.EnumType;

public class EnumParam
extends NamedTypedValue<EnumType, Integer> {
    public EnumParam(String name, EnumType type, AccessibleSchema accessibleSchema) {
        super(name, type, accessibleSchema);
    }

    @Override
    public Object newInstance() throws ClassNotFoundException {
        if (this.getValue() == null) {
            return null;
        }
        Class<?> clazz = Class.forName(((EnumType)this.getType()).getFullTypeName());
        String value = ((EnumType)this.getType()).getItems()[(Integer)this.getValue()];
        return Enum.valueOf(clazz, value);
    }

    @Override
    public List<String> referenceTypes() {
        return null;
    }

    @Override
    public ParamDto getDto() {
        ParamDto dto = super.getDto();
        if (this.getValue() != null) {
            dto.stringValue = ((Integer)this.getValue()).toString();
        }
        return dto;
    }

    public EnumParam copyStructure() {
        return new EnumParam(this.getName(), (EnumType)this.getType(), this.accessibleSchema);
    }

    @Override
    public void setValueBasedOnDto(ParamDto dto) {
        try {
            if (dto.stringValue != null) {
                this.setValue(Integer.parseInt(dto.stringValue));
            }
        }
        catch (NumberFormatException e) {
            throw new RuntimeException("ERROR: fail to convert " + dto.stringValue + " as int value for setting enum");
        }
    }

    @Override
    protected void setValueBasedOnValidInstance(Object instance) {
        Method m = null;
        try {
            m = instance.getClass().getMethod("ordinal", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("ERROR: fail to process setValueBasedOnValidInstance, with error msg:" + e.getMessage());
        }
        m.setAccessible(true);
        try {
            this.setValue(Integer.valueOf((Integer)m.invoke(instance, new Object[0])));
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException("ERROR: fail to process setValueBasedOnValidInstance, with error msg:" + e.getMessage());
        }
    }

    @Override
    public List<String> newInstanceWithJavaOrKotlin(boolean isDeclaration, boolean doesIncludeName, String variableName, int indent, boolean isJava, boolean isVariableNullable) {
        String code;
        if (this.accessibleSchema != null && this.accessibleSchema.setterMethodName != null) {
            code = CodeJavaOrKotlinGenerator.oneLineSetterInstance(this.accessibleSchema.setterMethodName, ((EnumType)this.getType()).getFullTypeName(), variableName, this.getValueAsJavaString(isJava), isJava, this.isNullable());
        } else {
            if (this.accessibleSchema != null && !this.accessibleSchema.isAccessible) {
                throw new IllegalStateException("Error: private field, but there is no setter method");
            }
            code = CodeJavaOrKotlinGenerator.oneLineInstance(isDeclaration, doesIncludeName, ((EnumType)this.getType()).getFullTypeName(), variableName, this.getValueAsJavaString(isJava), isJava, this.isNullable());
        }
        return Collections.singletonList(CodeJavaOrKotlinGenerator.getIndent(indent) + code);
    }

    @Override
    public List<String> newAssertionWithJavaOrKotlin(int indent, String responseVarName, int maxAssertionForDataInCollection, boolean isJava) {
        StringBuilder sb = new StringBuilder();
        sb.append(CodeJavaOrKotlinGenerator.getIndent(indent));
        if (this.getValue() == null) {
            sb.append(CodeJavaOrKotlinGenerator.junitAssertNull(responseVarName, isJava));
        } else {
            sb.append(CodeJavaOrKotlinGenerator.junitAssertEquals(CodeJavaOrKotlinGenerator.enumValue(((EnumType)this.getType()).getFullTypeName(), ((EnumType)this.getType()).getItems()[(Integer)this.getValue()]), responseVarName, isJava));
        }
        return Collections.singletonList(sb.toString());
    }

    @Override
    public String getValueAsJavaString(boolean isJava) {
        if (this.getValue() == null) {
            return null;
        }
        return CodeJavaOrKotlinGenerator.enumValue(((EnumType)this.getType()).getFullTypeName(), ((EnumType)this.getType()).getItems()[(Integer)this.getValue()]);
    }
}

