/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.controller.problem.rpc.schema.params;

import org.evomaster.client.java.controller.api.dto.problem.rpc.ParamDto;
import org.evomaster.client.java.controller.api.dto.problem.rpc.RPCSupportedDataType;
import org.evomaster.client.java.controller.problem.rpc.schema.params.PrimitiveOrWrapperParam;
import org.evomaster.client.java.controller.problem.rpc.schema.types.AccessibleSchema;
import org.evomaster.client.java.controller.problem.rpc.schema.types.JavaDtoSpec;
import org.evomaster.client.java.controller.problem.rpc.schema.types.PrimitiveOrWrapperType;

public class CharParam
extends PrimitiveOrWrapperParam<Character> {
    private static final String JAVA_PR_METHOD = "charValue";
    private static final String KOTLIN_PR_METHOD = "toChar";

    public CharParam(String name, String type, String fullTypeName, Class<?> clazz, AccessibleSchema accessibleSchema, JavaDtoSpec spec) {
        super(name, type, fullTypeName, clazz, accessibleSchema, spec);
    }

    public CharParam(String name, PrimitiveOrWrapperType type, AccessibleSchema accessibleSchema) {
        super(name, type, accessibleSchema);
    }

    @Override
    public ParamDto getDto() {
        ParamDto dto = super.getDto();
        dto.type.type = ((PrimitiveOrWrapperType)this.getType()).isWrapper ? RPCSupportedDataType.CHAR : RPCSupportedDataType.P_CHAR;
        if (this.getValue() != null) {
            dto.stringValue = ((Character)this.getValue()).toString();
        }
        return dto;
    }

    @Override
    public String getValueAsJavaString(boolean isJava) {
        if (this.getValue() == null) {
            return null;
        }
        return "'" + String.format("\\u%04x", ((Character)this.getValue()).charValue()) + "'";
    }

    public CharParam copyStructure() {
        return new CharParam(this.getName(), (PrimitiveOrWrapperType)this.getType(), this.accessibleSchema);
    }

    @Override
    public void setValueBasedOnStringValue(String stringValue) {
        if (stringValue == null) {
            return;
        }
        if (stringValue.length() > 1) {
            throw new RuntimeException("ERROR: a length of a char with its string value is more than 1, i.e., " + stringValue.length());
        }
        if (stringValue.length() == 1) {
            this.setValue(Character.valueOf(stringValue.charAt(0)));
        }
    }

    @Override
    protected void setValueBasedOnValidInstance(Object instance) {
        this.setValue((Character)instance);
    }

    @Override
    public boolean isValidInstance(Object instance) {
        return instance instanceof Character;
    }

    @Override
    public String primitiveValueMethod(boolean isJava) {
        if (isJava) {
            return JAVA_PR_METHOD;
        }
        return KOTLIN_PR_METHOD;
    }
}

