/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.controller.problem.rpc.schema.params;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.evomaster.client.java.controller.api.dto.problem.rpc.ParamDto;
import org.evomaster.client.java.controller.problem.rpc.CodeJavaOrKotlinGenerator;
import org.evomaster.client.java.controller.problem.rpc.schema.params.NamedTypedValue;
import org.evomaster.client.java.controller.problem.rpc.schema.params.NumericConstraintBase;
import org.evomaster.client.java.controller.problem.rpc.schema.types.AccessibleSchema;
import org.evomaster.client.java.controller.problem.rpc.schema.types.BigIntegerType;
import org.evomaster.client.java.controller.problem.rpc.schema.types.JavaDtoSpec;
import shaded.com.fasterxml.jackson.core.JsonProcessingException;

public class BigIntegerParam
extends NamedTypedValue<BigIntegerType, BigInteger>
implements NumericConstraintBase<BigInteger> {
    private BigInteger min;
    private BigInteger max;
    private boolean minInclusive = true;
    private boolean maxInclusive = true;
    private Integer precision;
    private Integer scale;

    public BigIntegerParam(String name, BigIntegerType type, AccessibleSchema accessibleSchema) {
        super(name, type, accessibleSchema);
    }

    public BigIntegerParam(String name, AccessibleSchema accessibleSchema, JavaDtoSpec spec) {
        this(name, new BigIntegerType(spec), accessibleSchema);
    }

    @Override
    public Object newInstance() throws ClassNotFoundException {
        return this.getValue();
    }

    @Override
    public NamedTypedValue<BigIntegerType, BigInteger> copyStructure() {
        return new BigIntegerParam(this.getName(), (BigIntegerType)this.getType(), this.accessibleSchema);
    }

    @Override
    public void copyProperties(NamedTypedValue copy) {
        super.copyProperties(copy);
        if (copy instanceof BigIntegerParam) {
            ((BigIntegerParam)copy).setMax(this.max);
            ((BigIntegerParam)copy).setMin(this.min);
        }
        this.handleConstraintsInCopy(copy);
    }

    private BigInteger parseValue(String stringValue) {
        if (stringValue == null) {
            return null;
        }
        return new BigInteger(stringValue);
    }

    @Override
    public void setValueBasedOnDto(ParamDto dto) {
        this.setValue(this.parseValue(dto.stringValue));
    }

    @Override
    public void setValueBasedOnInstanceOrJson(Object json) throws JsonProcessingException {
        if (json == null) {
            return;
        }
        this.setValue(this.parseValue(json.toString()));
    }

    @Override
    protected void setValueBasedOnValidInstance(Object instance) {
        this.setValue((BigInteger)instance);
    }

    @Override
    public ParamDto getDto() {
        ParamDto dto = super.getDto();
        this.handleConstraintsInCopyDto(dto);
        if (this.getValue() != null) {
            dto.stringValue = ((BigInteger)this.getValue()).toString();
        }
        return dto;
    }

    @Override
    public List<String> newInstanceWithJavaOrKotlin(boolean isDeclaration, boolean doesIncludeName, String variableName, int indent, boolean isJava, boolean isVariableNullable) {
        String typeName = ((BigIntegerType)this.getType()).getTypeNameForInstanceInJavaOrKotlin(isJava);
        ArrayList<String> codes = new ArrayList<String>();
        boolean isNull = this.getValue() == null;
        String var = CodeJavaOrKotlinGenerator.oneLineInstance(isDeclaration, doesIncludeName, typeName, variableName, null, isJava, this.isNullable());
        CodeJavaOrKotlinGenerator.addCode(codes, var, indent);
        if (isNull) {
            return codes;
        }
        CodeJavaOrKotlinGenerator.addCode(codes, CodeJavaOrKotlinGenerator.codeBlockStart(isJava), indent);
        CodeJavaOrKotlinGenerator.addCode(codes, CodeJavaOrKotlinGenerator.setInstance(variableName, CodeJavaOrKotlinGenerator.newObjectConsParams(typeName, this.getValueAsJavaString(isJava), isJava), isJava), indent + 1);
        CodeJavaOrKotlinGenerator.addCode(codes, CodeJavaOrKotlinGenerator.codeBlockEnd(isJava), indent);
        return codes;
    }

    @Override
    public List<String> newAssertionWithJavaOrKotlin(int indent, String responseVarName, int maxAssertionForDataInCollection, boolean isJava) {
        StringBuilder sb = new StringBuilder();
        sb.append(CodeJavaOrKotlinGenerator.getIndent(indent));
        if (this.getValue() == null) {
            sb.append(CodeJavaOrKotlinGenerator.junitAssertNull(responseVarName, isJava));
        } else {
            sb.append(CodeJavaOrKotlinGenerator.junitAssertEquals(this.getValueAsJavaString(isJava), responseVarName + ".toString()", isJava));
        }
        return Collections.singletonList(sb.toString());
    }

    @Override
    public String getValueAsJavaString(boolean isJava) {
        if (this.getValue() == null) {
            return null;
        }
        return "\"" + ((BigInteger)this.getValue()).toString() + "\"";
    }

    @Override
    public BigInteger getMin() {
        return this.min;
    }

    @Override
    public void setMin(BigInteger min) {
        if (this.min != null && this.min.compareTo(min) >= 0) {
            return;
        }
        this.min = min;
    }

    @Override
    public BigInteger getMax() {
        return this.max;
    }

    @Override
    public void setMax(BigInteger max) {
        if (this.max != null && this.max.compareTo(max) <= 0) {
            return;
        }
        this.max = max;
    }

    @Override
    public boolean getMinInclusive() {
        return this.minInclusive;
    }

    @Override
    public void setMinInclusive(boolean inclusive) {
        this.minInclusive = inclusive;
    }

    @Override
    public boolean getMaxInclusive() {
        return this.maxInclusive;
    }

    @Override
    public void setMaxInclusive(boolean inclusive) {
        this.maxInclusive = inclusive;
    }

    @Override
    public Integer getPrecision() {
        return this.precision;
    }

    @Override
    public void setPrecision(Integer precision) {
        this.precision = precision;
    }

    @Override
    public Integer getScale() {
        return this.scale;
    }

    @Override
    public void setScale(Integer scale) {
        this.scale = scale;
    }

    @Override
    public List<String> referenceTypes() {
        return null;
    }
}

