/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.controller.problem.rpc.schema;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.evomaster.client.java.controller.DtoUtils;
import org.evomaster.client.java.controller.api.dto.SutInfoDto;
import org.evomaster.client.java.controller.api.dto.problem.rpc.RPCActionDto;
import org.evomaster.client.java.controller.api.dto.problem.rpc.SeededRPCActionDto;
import org.evomaster.client.java.controller.problem.rpc.CodeJavaOrKotlinGenerator;
import org.evomaster.client.java.controller.problem.rpc.schema.params.NamedTypedValue;
import org.evomaster.client.java.controller.problem.rpc.schema.types.PrimitiveOrWrapperType;
import org.evomaster.client.java.controller.problem.rpc.schema.types.TypeSchema;

public class EndpointSchema {
    private final String name;
    private final String interfaceName;
    private final String clientTypeName;
    private final List<NamedTypedValue> requestParams;
    private final NamedTypedValue response;
    private final List<NamedTypedValue> exceptions;
    private final boolean authRequired;
    private final List<Integer> requiredAuthCandidates;
    private final Set<String> relatedCustomizedCandidates;

    public Set<String> getRelatedCustomizedCandidates() {
        return this.relatedCustomizedCandidates;
    }

    public EndpointSchema(String name, String interfaceName, String clientTypeName, List<NamedTypedValue> requestParams, NamedTypedValue response, List<NamedTypedValue> exceptions, boolean authRequired, List<Integer> requiredAuthCandidates, Set<String> relatedCustomizedCandidates) {
        this.name = name;
        this.interfaceName = interfaceName;
        this.clientTypeName = clientTypeName;
        this.requestParams = requestParams;
        this.response = response;
        this.exceptions = exceptions;
        this.authRequired = authRequired;
        this.requiredAuthCandidates = requiredAuthCandidates;
        this.relatedCustomizedCandidates = relatedCustomizedCandidates;
    }

    public String getName() {
        return this.name;
    }

    public List<NamedTypedValue> getRequestParams() {
        return this.requestParams;
    }

    public NamedTypedValue getResponse() {
        return this.response;
    }

    public List<NamedTypedValue> getExceptions() {
        return this.exceptions;
    }

    public RPCActionDto getDto() {
        RPCActionDto dto = new RPCActionDto();
        dto.actionName = this.name;
        dto.interfaceId = this.interfaceName;
        dto.clientInfo = this.clientTypeName;
        if (this.requestParams != null) {
            dto.requestParams = this.requestParams.stream().map(NamedTypedValue::getDto).collect(Collectors.toList());
        }
        if (this.response != null) {
            dto.responseParam = this.response.getDto();
        }
        if (this.relatedCustomizedCandidates != null) {
            dto.relatedCustomization = new HashSet<String>(this.relatedCustomizedCandidates);
        }
        if (this.requiredAuthCandidates != null) {
            dto.requiredAuthCandidates = new ArrayList<Integer>(this.requiredAuthCandidates);
        }
        dto.isAuthorized = this.authRequired;
        return dto;
    }

    public boolean sameEndpoint(RPCActionDto dto) {
        return dto.actionName.equals(this.name) && (this.getRequestParams() == null && dto.requestParams == null || this.getRequestParams().size() == dto.requestParams.size()) && IntStream.range(0, this.getRequestParams().size()).allMatch(i -> this.getRequestParams().get(i).sameParam(dto.requestParams.get(i)));
    }

    public boolean sameEndpoint(SeededRPCActionDto dto) {
        return dto.functionName.equals(this.name) && (this.getRequestParams() == null && dto.inputParamTypes == null || this.getRequestParams().size() == dto.inputParamTypes.size()) && IntStream.range(0, this.getRequestParams().size()).allMatch(i -> ((TypeSchema)this.getRequestParams().get(i).getType()).getFullTypeName().equals(dto.inputParamTypes.get(i)));
    }

    public EndpointSchema copyStructure() {
        return new EndpointSchema(this.name, this.interfaceName, this.clientTypeName, this.requestParams == null ? null : this.requestParams.stream().map(NamedTypedValue::copyStructureWithProperties).collect(Collectors.toList()), this.response == null ? null : this.response.copyStructureWithProperties(), this.exceptions == null ? null : this.exceptions.stream().map(NamedTypedValue::copyStructureWithProperties).collect(Collectors.toList()), this.authRequired, this.requiredAuthCandidates, this.relatedCustomizedCandidates);
    }

    public void setValue(RPCActionDto dto) {
        if (dto.requestParams != null) {
            IntStream.range(0, dto.requestParams.size()).forEach(s -> this.requestParams.get(s).setValueBasedOnDto(dto.requestParams.get(s)));
        }
        if (dto.responseParam != null) {
            this.response.setValueBasedOnDto(dto.responseParam);
        }
    }

    public List<String> newInvocationWithJavaOrKotlin(String responseVarName, String controllerVarName, String clientVariable, SutInfoDto.OutputFormat outputFormat) {
        ArrayList<String> javaCode = new ArrayList<String>();
        if (this.response != null) {
            boolean isPrimitive = this.response.getType() instanceof PrimitiveOrWrapperType && !((PrimitiveOrWrapperType)this.response.getType()).isWrapper;
            javaCode.add(CodeJavaOrKotlinGenerator.oneLineInstance(true, true, ((TypeSchema)this.response.getType()).getTypeNameForInstanceInJavaOrKotlin(DtoUtils.isJava(outputFormat)), responseVarName, null, isPrimitive, DtoUtils.isJava(outputFormat), this.response.isNullable()));
        }
        javaCode.add(CodeJavaOrKotlinGenerator.codeBlockStart(DtoUtils.isJava(outputFormat)));
        int indent = 1;
        for (NamedTypedValue param : this.getRequestParams()) {
            javaCode.addAll(param.newInstanceWithJavaOrKotlin(indent, DtoUtils.isJava(outputFormat), param.isNullable()));
        }
        String paramVars = this.requestParams.stream().map(NamedTypedValue::getName).collect(Collectors.joining(","));
        String client = clientVariable;
        if (client == null) {
            client = CodeJavaOrKotlinGenerator.castToType(this.clientTypeName, CodeJavaOrKotlinGenerator.getGetClientMethod(controllerVarName, "\"" + CodeJavaOrKotlinGenerator.handleEscapeCharInString(this.interfaceName, DtoUtils.isJava(outputFormat)) + "\""), DtoUtils.isJava(outputFormat));
        }
        if (client == null) {
            throw new IllegalArgumentException("fail to generate code for accessing client :" + this.clientTypeName);
        }
        CodeJavaOrKotlinGenerator.addCode(javaCode, CodeJavaOrKotlinGenerator.setInstance(this.response != null, responseVarName, CodeJavaOrKotlinGenerator.methodInvocation(client, this.getName(), paramVars, DtoUtils.isJava(outputFormat), this.response != null ? this.response.isNullable() : true, false), DtoUtils.isJava(outputFormat)), indent);
        javaCode.add(CodeJavaOrKotlinGenerator.codeBlockEnd(DtoUtils.isJava(outputFormat)));
        return javaCode;
    }
}

