/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.controller.problem;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.evomaster.client.java.controller.api.dto.problem.rpc.RPCType;
import org.evomaster.client.java.controller.problem.ExternalService;
import org.evomaster.client.java.controller.problem.ProblemInfo;

public class RPCProblem
extends ProblemInfo {
    private final Map<String, Object> mapOfInterfaceAndClient;
    private final RPCType type;
    private final Map<String, List<String>> skipEndpointsByName;
    private final Map<String, List<String>> skipEndpointsByAnnotation;
    private final Map<String, List<String>> involveEndpointsByName;
    private final Map<String, List<String>> involveEndpointsByAnnotation;

    public <T, K extends T> RPCProblem(final Class<T> interfaceClass, final K client, RPCType type) {
        this((Map<String, Object>)new HashMap<String, Object>(){
            {
                this.put(interfaceClass.getName(), client);
            }
        }, type);
    }

    public RPCProblem(Map<String, Object> mapOfInterfaceAndClient) {
        this(mapOfInterfaceAndClient, RPCType.GENERAL);
    }

    public RPCProblem(Map<String, Object> mapOfInterfaceAndClient, RPCType type) {
        this(mapOfInterfaceAndClient, null, null, null, null, type);
    }

    public RPCProblem(Map<String, Object> mapOfInterfaceAndClient, Map<String, List<String>> skipEndpointsByName, Map<String, List<String>> skipEndpointsByAnnotation, Map<String, List<String>> involveEndpointsByName, Map<String, List<String>> involveEndpointsByAnnotation, RPCType type) {
        this.mapOfInterfaceAndClient = mapOfInterfaceAndClient == null ? new HashMap<String, Object>() : new HashMap<String, Object>(mapOfInterfaceAndClient);
        this.involveEndpointsByAnnotation = involveEndpointsByAnnotation == null ? new HashMap<String, List<String>>() : new HashMap<String, List<String>>(involveEndpointsByAnnotation);
        this.involveEndpointsByName = involveEndpointsByName == null ? new HashMap<String, List<String>>() : new HashMap<String, List<String>>(involveEndpointsByName);
        this.skipEndpointsByAnnotation = skipEndpointsByAnnotation == null ? new HashMap<String, List<String>>() : new HashMap<String, List<String>>(skipEndpointsByAnnotation);
        this.skipEndpointsByName = skipEndpointsByName == null ? new HashMap<String, List<String>>() : new HashMap<String, List<String>>(skipEndpointsByName);
        this.type = type;
    }

    public Set<String> getKeysOfMapOfInterfaceAndClient() {
        return this.mapOfInterfaceAndClient.keySet();
    }

    public RPCType getType() {
        return this.type;
    }

    public Map<String, Object> getMapOfInterfaceAndClient() {
        return Collections.unmodifiableMap(this.mapOfInterfaceAndClient);
    }

    public Map<String, List<String>> getSkipEndpointsByName() {
        return Collections.unmodifiableMap(this.skipEndpointsByName);
    }

    public Map<String, List<String>> getSkipEndpointsByAnnotation() {
        return Collections.unmodifiableMap(this.skipEndpointsByAnnotation);
    }

    public Map<String, List<String>> getInvolveEndpointsByName() {
        return Collections.unmodifiableMap(this.involveEndpointsByName);
    }

    public Map<String, List<String>> getInvolveEndpointsByAnnotation() {
        return Collections.unmodifiableMap(this.involveEndpointsByAnnotation);
    }

    public Object getClient(String interfaceId) {
        return this.mapOfInterfaceAndClient.get(interfaceId);
    }

    @Override
    public RPCProblem withServicesToNotMock(List<ExternalService> servicesToNotMock) {
        RPCProblem p = new RPCProblem(this.mapOfInterfaceAndClient, this.skipEndpointsByName, this.skipEndpointsByAnnotation, this.involveEndpointsByName, this.involveEndpointsByAnnotation, this.type);
        p.servicesToNotMock.addAll(servicesToNotMock);
        return p;
    }
}

