/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.controller.mongo.utils;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Set;

public class BsonHelper {
    public static Object newDocument(Object document) {
        try {
            return document.getClass().getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static void appendToDocument(Object document, String fieldName, Object value) {
        try {
            Method append = document.getClass().getMethod("append", String.class, Object.class);
            append.invoke(document, fieldName, value);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static Object getValue(Object document, String fieldName) {
        try {
            return document.getClass().getMethod("get", Object.class).invoke(document, fieldName);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static Set<String> keySet(Object document) {
        try {
            return (Set)document.getClass().getMethod("keySet", new Class[0]).invoke(document, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static Boolean documentContainsField(Object document, String field) {
        try {
            return (Boolean)document.getClass().getMethod("containsKey", Object.class).invoke(document, field);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static Set<String> documentKeys(Object document) {
        try {
            return (Set)document.getClass().getMethod("keySet", new Class[0]).invoke(document, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static Boolean isDocument(Object value) {
        return value.getClass().getName().equals("org.bson.Document");
    }

    public static String getType(Object bsonType) {
        try {
            ClassLoader bsonTypeClassLoader = bsonType.getClass().getClassLoader();
            Class<?> bsonTypeClassMapClass = bsonTypeClassLoader.loadClass("org.bson.codecs.BsonTypeClassMap");
            Class<?> bsonTypeClass = bsonTypeClassLoader.loadClass("org.bson.BsonType");
            Object bsonTypeClassMap = bsonTypeClassMapClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            Method get = bsonTypeClassMapClass.getMethod("get", bsonTypeClass);
            Object type = get.invoke(bsonTypeClassMap, bsonType);
            return (String)type.getClass().getMethod("getTypeName", new Class[0]).invoke(type, null);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static Object getTypeFromNumber(Integer number) {
        try {
            Class<?> bsonTypeClass = Class.forName("org.bson.BsonType");
            Method findByValue = bsonTypeClass.getMethod("findByValue", Integer.TYPE);
            return findByValue.invoke(null, number);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static Object getTypeFromAlias(String alias) {
        try {
            Class<?> bsonTypeClass = Class.forName("org.bson.BsonType");
            Method valueOf = bsonTypeClass.getMethod("valueOf", String.class);
            return valueOf.invoke(null, alias);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }
}

