/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.controller.mongo;

public class MongoOperation {
    private final Object query;
    private final String collectionName;
    private final String databaseName;
    private final String documentsType;
    private final String queryClass = "org.bson.conversions.Bson";

    public MongoOperation(String collectionName, Object query, String databaseName, String documentsType) {
        if (!this.isImplementationOfBson(query)) {
            throw new IllegalArgumentException("query must be of type org.bson.conversions.Bson");
        }
        this.collectionName = collectionName;
        this.databaseName = databaseName;
        this.documentsType = documentsType;
        this.query = query;
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public Object getQuery() {
        return this.query;
    }

    public String getDocumentsType() {
        return this.documentsType;
    }

    private boolean isImplementationOfBson(Object obj) {
        Class<?>[] interfaces;
        for (Class<?> intf : interfaces = obj.getClass().getInterfaces()) {
            if (!intf.getName().equals("org.bson.conversions.Bson")) continue;
            return true;
        }
        return false;
    }
}

