/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.jgrapht.alg;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import shaded.org.jgrapht.DirectedGraph;
import shaded.org.jgrapht.Graph;
import shaded.org.jgrapht.UndirectedGraph;
import shaded.org.jgrapht.event.ConnectedComponentTraversalEvent;
import shaded.org.jgrapht.event.GraphEdgeChangeEvent;
import shaded.org.jgrapht.event.GraphListener;
import shaded.org.jgrapht.event.GraphVertexChangeEvent;
import shaded.org.jgrapht.event.TraversalListenerAdapter;
import shaded.org.jgrapht.event.VertexTraversalEvent;
import shaded.org.jgrapht.graph.AsUndirectedGraph;
import shaded.org.jgrapht.traverse.BreadthFirstIterator;

public class ConnectivityInspector<V, E>
implements GraphListener<V, E> {
    List<Set<V>> connectedSets;
    Map<V, Set<V>> vertexToConnectedSet;
    private Graph<V, E> graph;

    public ConnectivityInspector(UndirectedGraph<V, E> undirectedGraph) {
        this.init();
        this.graph = undirectedGraph;
    }

    public ConnectivityInspector(DirectedGraph<V, E> directedGraph) {
        this.init();
        this.graph = new AsUndirectedGraph<V, E>(directedGraph);
    }

    public boolean isGraphConnected() {
        return this.lazyFindConnectedSets().size() == 1;
    }

    public Set<V> connectedSetOf(V v) {
        Set<V> set = this.vertexToConnectedSet.get(v);
        if (set == null) {
            set = new HashSet<V>();
            BreadthFirstIterator<V, E> breadthFirstIterator = new BreadthFirstIterator<V, E>(this.graph, v);
            while (breadthFirstIterator.hasNext()) {
                set.add(breadthFirstIterator.next());
            }
            this.vertexToConnectedSet.put((Set<V>)v, (Set<Set<V>>)set);
        }
        return set;
    }

    public List<Set<V>> connectedSets() {
        return this.lazyFindConnectedSets();
    }

    @Override
    public void edgeAdded(GraphEdgeChangeEvent<V, E> graphEdgeChangeEvent) {
        this.init();
    }

    @Override
    public void edgeRemoved(GraphEdgeChangeEvent<V, E> graphEdgeChangeEvent) {
        this.init();
    }

    public boolean pathExists(V v, V v2) {
        Set<V> set = this.connectedSetOf(v);
        return set.contains(v2);
    }

    @Override
    public void vertexAdded(GraphVertexChangeEvent<V> graphVertexChangeEvent) {
        this.init();
    }

    @Override
    public void vertexRemoved(GraphVertexChangeEvent<V> graphVertexChangeEvent) {
        this.init();
    }

    private void init() {
        this.connectedSets = null;
        this.vertexToConnectedSet = new HashMap<V, Set<V>>();
    }

    private List<Set<V>> lazyFindConnectedSets() {
        if (this.connectedSets == null) {
            this.connectedSets = new ArrayList<Set<V>>();
            Set<V> set = this.graph.vertexSet();
            if (set.size() > 0) {
                BreadthFirstIterator<Object, E> breadthFirstIterator = new BreadthFirstIterator<Object, E>(this.graph, null);
                breadthFirstIterator.addTraversalListener(new MyTraversalListener());
                while (breadthFirstIterator.hasNext()) {
                    breadthFirstIterator.next();
                }
            }
        }
        return this.connectedSets;
    }

    private class MyTraversalListener
    extends TraversalListenerAdapter<V, E> {
        private Set<V> currentConnectedSet;

        private MyTraversalListener() {
        }

        @Override
        public void connectedComponentFinished(ConnectedComponentTraversalEvent connectedComponentTraversalEvent) {
            ConnectivityInspector.this.connectedSets.add(this.currentConnectedSet);
        }

        @Override
        public void connectedComponentStarted(ConnectedComponentTraversalEvent connectedComponentTraversalEvent) {
            this.currentConnectedSet = new HashSet();
        }

        @Override
        public void vertexTraversed(VertexTraversalEvent<V> vertexTraversalEvent) {
            Object v = vertexTraversalEvent.getVertex();
            this.currentConnectedSet.add(v);
            ConnectivityInspector.this.vertexToConnectedSet.put((Set)v, (Set)this.currentConnectedSet);
        }
    }
}

