/*
 * Decompiled with CFR 0.152.
 */
package shaded.net.sf.jsqlparser.util.deparser;

import java.util.Iterator;
import shaded.net.sf.jsqlparser.expression.ExpressionVisitor;
import shaded.net.sf.jsqlparser.expression.ExpressionVisitorAdapter;
import shaded.net.sf.jsqlparser.statement.select.Join;
import shaded.net.sf.jsqlparser.statement.select.OrderByElement;
import shaded.net.sf.jsqlparser.statement.select.OrderByVisitor;
import shaded.net.sf.jsqlparser.statement.select.SelectExpressionItem;
import shaded.net.sf.jsqlparser.statement.select.WithItem;
import shaded.net.sf.jsqlparser.statement.update.Update;
import shaded.net.sf.jsqlparser.statement.update.UpdateSet;
import shaded.net.sf.jsqlparser.util.deparser.AbstractDeParser;
import shaded.net.sf.jsqlparser.util.deparser.LimitDeparser;
import shaded.net.sf.jsqlparser.util.deparser.OrderByDeParser;

public class UpdateDeParser
extends AbstractDeParser<Update>
implements OrderByVisitor {
    private ExpressionVisitor expressionVisitor = new ExpressionVisitorAdapter();

    public UpdateDeParser() {
        super(new StringBuilder());
    }

    public UpdateDeParser(ExpressionVisitor expressionVisitor, StringBuilder buffer) {
        super(buffer);
        this.expressionVisitor = expressionVisitor;
    }

    @Override
    public void deParse(Update update) {
        if (update.getWithItemsList() != null && !update.getWithItemsList().isEmpty()) {
            this.buffer.append("WITH ");
            Iterator<Object> iter = update.getWithItemsList().iterator();
            while (iter.hasNext()) {
                WithItem withItem = (WithItem)iter.next();
                this.buffer.append(withItem);
                if (iter.hasNext()) {
                    this.buffer.append(",");
                }
                this.buffer.append(" ");
            }
        }
        this.buffer.append("UPDATE ").append(update.getTable());
        if (update.getStartJoins() != null) {
            for (Join join : update.getStartJoins()) {
                if (join.isSimple()) {
                    this.buffer.append(", ").append(join);
                    continue;
                }
                this.buffer.append(" ").append(join);
            }
        }
        this.buffer.append(" SET ");
        int j = 0;
        for (UpdateSet updateSet : update.getUpdateSets()) {
            int i;
            if (j > 0) {
                this.buffer.append(", ");
            }
            if (updateSet.isUsingBracketsForColumns()) {
                this.buffer.append("(");
            }
            for (i = 0; i < updateSet.getColumns().size(); ++i) {
                if (i > 0) {
                    this.buffer.append(", ");
                }
                updateSet.getColumns().get(i).accept(this.expressionVisitor);
            }
            if (updateSet.isUsingBracketsForColumns()) {
                this.buffer.append(")");
            }
            this.buffer.append(" = ");
            if (updateSet.isUsingBracketsForValues()) {
                this.buffer.append("(");
            }
            for (i = 0; i < updateSet.getExpressions().size(); ++i) {
                if (i > 0) {
                    this.buffer.append(", ");
                }
                updateSet.getExpressions().get(i).accept(this.expressionVisitor);
            }
            if (updateSet.isUsingBracketsForValues()) {
                this.buffer.append(")");
            }
            ++j;
        }
        if (update.getFromItem() != null) {
            this.buffer.append(" FROM ").append(update.getFromItem());
            if (update.getJoins() != null) {
                for (Join join : update.getJoins()) {
                    if (join.isSimple()) {
                        this.buffer.append(", ").append(join);
                        continue;
                    }
                    this.buffer.append(" ").append(join);
                }
            }
        }
        if (update.getWhere() != null) {
            this.buffer.append(" WHERE ");
            update.getWhere().accept(this.expressionVisitor);
        }
        if (update.getOrderByElements() != null) {
            new OrderByDeParser(this.expressionVisitor, this.buffer).deParse(update.getOrderByElements());
        }
        if (update.getLimit() != null) {
            new LimitDeparser(this.buffer).deParse(update.getLimit());
        }
        if (update.isReturningAllColumns()) {
            this.buffer.append(" RETURNING *");
        } else if (update.getReturningExpressionList() != null) {
            this.buffer.append(" RETURNING ");
            Iterator<SelectExpressionItem> iterator = update.getReturningExpressionList().iterator();
            while (iterator.hasNext()) {
                this.buffer.append(iterator.next().toString());
                if (!iterator.hasNext()) continue;
                this.buffer.append(", ");
            }
        }
    }

    public ExpressionVisitor getExpressionVisitor() {
        return this.expressionVisitor;
    }

    public void setExpressionVisitor(ExpressionVisitor visitor) {
        this.expressionVisitor = visitor;
    }

    @Override
    public void visit(OrderByElement orderBy) {
        orderBy.getExpression().accept(this.expressionVisitor);
        if (!orderBy.isAsc()) {
            this.buffer.append(" DESC");
        } else if (orderBy.isAscDescPresent()) {
            this.buffer.append(" ASC");
        }
        if (orderBy.getNullOrdering() != null) {
            this.buffer.append(' ');
            this.buffer.append(orderBy.getNullOrdering() == OrderByElement.NullOrdering.NULLS_FIRST ? "NULLS FIRST" : "NULLS LAST");
        }
    }
}

