/*
 * Decompiled with CFR 0.152.
 */
package shaded.net.sf.jsqlparser.statement.select;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import shaded.net.sf.jsqlparser.expression.Alias;
import shaded.net.sf.jsqlparser.schema.Column;
import shaded.net.sf.jsqlparser.statement.select.ExpressionListItem;
import shaded.net.sf.jsqlparser.statement.select.FunctionItem;
import shaded.net.sf.jsqlparser.statement.select.PivotVisitor;
import shaded.net.sf.jsqlparser.statement.select.PlainSelect;
import shaded.net.sf.jsqlparser.statement.select.SelectExpressionItem;

public class Pivot {
    private List<FunctionItem> functionItems;
    private List<Column> forColumns;
    private List<SelectExpressionItem> singleInItems;
    private List<ExpressionListItem> multiInItems;
    private Alias alias;

    public void accept(PivotVisitor pivotVisitor) {
        pivotVisitor.visit(this);
    }

    public List<SelectExpressionItem> getSingleInItems() {
        return this.singleInItems;
    }

    public void setSingleInItems(List<SelectExpressionItem> singleInItems) {
        this.singleInItems = singleInItems;
    }

    public List<ExpressionListItem> getMultiInItems() {
        return this.multiInItems;
    }

    public void setMultiInItems(List<ExpressionListItem> multiInItems) {
        this.multiInItems = multiInItems;
    }

    public List<FunctionItem> getFunctionItems() {
        return this.functionItems;
    }

    public void setFunctionItems(List<FunctionItem> functionItems) {
        this.functionItems = functionItems;
    }

    public List<Column> getForColumns() {
        return this.forColumns;
    }

    public void setForColumns(List<Column> forColumns) {
        this.forColumns = forColumns;
    }

    public List<?> getInItems() {
        return this.singleInItems == null ? this.multiInItems : this.singleInItems;
    }

    public Alias getAlias() {
        return this.alias;
    }

    public void setAlias(Alias alias) {
        this.alias = alias;
    }

    public String toString() {
        return "PIVOT (" + PlainSelect.getStringList(this.functionItems) + " FOR " + PlainSelect.getStringList(this.forColumns, true, this.forColumns != null && this.forColumns.size() > 1) + " IN " + PlainSelect.getStringList(this.getInItems(), true, true) + ")" + (this.alias != null ? this.alias.toString() : "");
    }

    public Pivot withFunctionItems(List<FunctionItem> functionItems) {
        this.setFunctionItems(functionItems);
        return this;
    }

    public Pivot withForColumns(List<Column> forColumns) {
        this.setForColumns(forColumns);
        return this;
    }

    public Pivot withSingleInItems(List<SelectExpressionItem> singleInItems) {
        this.setSingleInItems(singleInItems);
        return this;
    }

    public Pivot withMultiInItems(List<ExpressionListItem> multiInItems) {
        this.setMultiInItems(multiInItems);
        return this;
    }

    public Pivot withAlias(Alias alias) {
        this.setAlias(alias);
        return this;
    }

    public Pivot addFunctionItems(FunctionItem ... functionItems) {
        List collection = Optional.ofNullable(this.getFunctionItems()).orElseGet(ArrayList::new);
        Collections.addAll(collection, functionItems);
        return this.withFunctionItems(collection);
    }

    public Pivot addFunctionItems(Collection<? extends FunctionItem> functionItems) {
        List collection = Optional.ofNullable(this.getFunctionItems()).orElseGet(ArrayList::new);
        collection.addAll(functionItems);
        return this.withFunctionItems(collection);
    }

    public Pivot addForColumns(Column ... forColumns) {
        List collection = Optional.ofNullable(this.getForColumns()).orElseGet(ArrayList::new);
        Collections.addAll(collection, forColumns);
        return this.withForColumns(collection);
    }

    public Pivot addForColumns(Collection<? extends Column> forColumns) {
        List collection = Optional.ofNullable(this.getForColumns()).orElseGet(ArrayList::new);
        collection.addAll(forColumns);
        return this.withForColumns(collection);
    }

    public Pivot addSingleInItems(SelectExpressionItem ... singleInItems) {
        List collection = Optional.ofNullable(this.getSingleInItems()).orElseGet(ArrayList::new);
        Collections.addAll(collection, singleInItems);
        return this.withSingleInItems(collection);
    }

    public Pivot addSingleInItems(Collection<? extends SelectExpressionItem> singleInItems) {
        List collection = Optional.ofNullable(this.getSingleInItems()).orElseGet(ArrayList::new);
        collection.addAll(singleInItems);
        return this.withSingleInItems(collection);
    }

    public Pivot addMultiInItems(ExpressionListItem ... multiInItems) {
        List collection = Optional.ofNullable(this.getMultiInItems()).orElseGet(ArrayList::new);
        Collections.addAll(collection, multiInItems);
        return this.withMultiInItems(collection);
    }

    public Pivot addMultiInItems(Collection<? extends ExpressionListItem> multiInItems) {
        List collection = Optional.ofNullable(this.getMultiInItems()).orElseGet(ArrayList::new);
        collection.addAll(multiInItems);
        return this.withMultiInItems(collection);
    }
}

