/*
 * Decompiled with CFR 0.152.
 */
package shaded.net.sf.jsqlparser.expression;

import java.util.ArrayList;
import java.util.Objects;
import shaded.net.sf.jsqlparser.expression.Expression;
import shaded.net.sf.jsqlparser.expression.ExpressionVisitor;
import shaded.net.sf.jsqlparser.expression.JsonAggregateOnNullType;
import shaded.net.sf.jsqlparser.expression.JsonAggregateUniqueKeysType;
import shaded.net.sf.jsqlparser.expression.JsonFunctionExpression;
import shaded.net.sf.jsqlparser.expression.JsonFunctionType;
import shaded.net.sf.jsqlparser.expression.JsonKeyValuePair;
import shaded.net.sf.jsqlparser.parser.ASTNodeAccessImpl;

public class JsonFunction
extends ASTNodeAccessImpl
implements Expression {
    private JsonFunctionType functionType;
    private final ArrayList<JsonKeyValuePair> keyValuePairs = new ArrayList();
    private final ArrayList<JsonFunctionExpression> expressions = new ArrayList();
    private JsonAggregateOnNullType onNullType;
    private JsonAggregateUniqueKeysType uniqueKeysType;

    public ArrayList<JsonKeyValuePair> getKeyValuePairs() {
        return this.keyValuePairs;
    }

    public ArrayList<JsonFunctionExpression> getExpressions() {
        return this.expressions;
    }

    public JsonKeyValuePair getKeyValuePair(int i) {
        return this.keyValuePairs.get(i);
    }

    public JsonFunctionExpression getExpression(int i) {
        return this.expressions.get(i);
    }

    public boolean add(JsonKeyValuePair keyValuePair) {
        return this.keyValuePairs.add(keyValuePair);
    }

    public void add(int i, JsonKeyValuePair keyValuePair) {
        this.keyValuePairs.add(i, keyValuePair);
    }

    public boolean add(JsonFunctionExpression expression) {
        return this.expressions.add(expression);
    }

    public void add(int i, JsonFunctionExpression expression) {
        this.expressions.add(i, expression);
    }

    public JsonAggregateOnNullType getOnNullType() {
        return this.onNullType;
    }

    public void setOnNullType(JsonAggregateOnNullType onNullType) {
        this.onNullType = onNullType;
    }

    public JsonFunction withOnNullType(JsonAggregateOnNullType onNullType) {
        this.setOnNullType(onNullType);
        return this;
    }

    public JsonAggregateUniqueKeysType getUniqueKeysType() {
        return this.uniqueKeysType;
    }

    public void setUniqueKeysType(JsonAggregateUniqueKeysType uniqueKeysType) {
        this.uniqueKeysType = uniqueKeysType;
    }

    public JsonFunction withUniqueKeysType(JsonAggregateUniqueKeysType uniqueKeysType) {
        this.setUniqueKeysType(uniqueKeysType);
        return this;
    }

    public JsonFunctionType getType() {
        return this.functionType;
    }

    public void setType(JsonFunctionType type) {
        this.functionType = Objects.requireNonNull(type, "The Type of the JSON Aggregate Function must not be null");
    }

    public JsonFunction withType(JsonFunctionType type) {
        this.setType(type);
        return this;
    }

    public void setType(String typeName) {
        this.functionType = JsonFunctionType.valueOf(Objects.requireNonNull(typeName, "The Type of the JSON Aggregate Function must not be null").toUpperCase());
    }

    public JsonFunction withType(String typeName) {
        this.setType(typeName);
        return this;
    }

    @Override
    public void accept(ExpressionVisitor expressionVisitor) {
        expressionVisitor.visit(this);
    }

    public StringBuilder append(StringBuilder builder) {
        switch (this.functionType) {
            case OBJECT: {
                this.appendObject(builder);
                break;
            }
            case ARRAY: {
                this.appendArray(builder);
                break;
            }
            default: {
                throw new UnsupportedOperationException("JSON Aggregate Function of the type " + this.functionType.name() + " has not been implemented yet.");
            }
        }
        return builder;
    }

    public StringBuilder appendObject(StringBuilder builder) {
        builder.append("JSON_OBJECT( ");
        int i = 0;
        for (JsonKeyValuePair keyValuePair : this.keyValuePairs) {
            if (i > 0) {
                builder.append(", ");
            }
            if (keyValuePair.isUsingValueKeyword()) {
                if (keyValuePair.isUsingKeyKeyword()) {
                    builder.append("KEY ");
                }
                builder.append(keyValuePair.getKey()).append(" VALUE ").append(keyValuePair.getValue());
            } else {
                builder.append(keyValuePair.getKey()).append(":").append(keyValuePair.getValue());
            }
            if (keyValuePair.isUsingFormatJson()) {
                builder.append(" FORMAT JSON");
            }
            ++i;
        }
        if (this.onNullType != null) {
            switch (this.onNullType) {
                case NULL: {
                    builder.append(" NULL ON NULL");
                    break;
                }
                case ABSENT: {
                    builder.append(" ABSENT On NULL");
                    break;
                }
            }
        }
        if (this.uniqueKeysType != null) {
            switch (this.uniqueKeysType) {
                case WITH: {
                    builder.append(" WITH UNIQUE KEYS");
                    break;
                }
                case WITHOUT: {
                    builder.append(" WITHOUT UNIQUE KEYS");
                    break;
                }
            }
        }
        builder.append(" ) ");
        return builder;
    }

    public StringBuilder appendArray(StringBuilder builder) {
        builder.append("JSON_ARRAY( ");
        int i = 0;
        for (JsonFunctionExpression expr : this.expressions) {
            if (i > 0) {
                builder.append(", ");
            }
            expr.append(builder);
            ++i;
        }
        if (this.onNullType != null) {
            switch (this.onNullType) {
                case NULL: {
                    builder.append(" NULL ON NULL ");
                    break;
                }
                case ABSENT: {
                    builder.append(" ABSENT On NULL ");
                    break;
                }
            }
        }
        builder.append(") ");
        return builder;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        return this.append(builder).toString();
    }
}

