/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.instrumentation.coverage.methodreplacement.classes;

import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.util.Objects;
import org.evomaster.client.java.instrumentation.ExternalServiceInfo;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.MethodReplacementClass;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.Replacement;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.UsageFilter;
import org.evomaster.client.java.instrumentation.shared.ReplacementCategory;
import org.evomaster.client.java.instrumentation.shared.ReplacementType;
import org.evomaster.client.java.instrumentation.staticstate.ExecutionTracer;

public class URLClassReplacement
implements MethodReplacementClass {
    @Override
    public Class<?> getTargetClass() {
        return URL.class;
    }

    @Replacement(type=ReplacementType.TRACKER, category=ReplacementCategory.NET, id="URL_openConnection_Replacement", replacingStatic=false, usageFilter=UsageFilter.ANY)
    public static URLConnection openConnection(URL caller) throws IOException {
        Objects.requireNonNull(caller);
        if (caller.getProtocol().equals("http") || caller.getProtocol().equals("https")) {
            int port = caller.getPort();
            String protocol = caller.getProtocol();
            if (port == -1) {
                switch (protocol) {
                    case "https": {
                        port = 443;
                        break;
                    }
                    case "http": {
                        port = 80;
                    }
                }
            }
            ExternalServiceInfo remoteHostInfo = new ExternalServiceInfo(protocol, caller.getHost(), port);
            ExecutionTracer.addExternalServiceHost(remoteHostInfo);
            if (ExecutionTracer.hasExternalMapping(caller.getHost())) {
                String ip = ExecutionTracer.getExternalMapping(caller.getHost());
                String url = "http://" + ip + ":" + caller.getPort() + caller.getPath();
                URL newURL = new URL(url);
                return newURL.openConnection();
            }
            throw new UnknownHostException("There is no WireMock initiated for this hostname");
        }
        return caller.openConnection();
    }
}

