/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.controller.problem.rpc;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.evomaster.client.java.controller.api.dto.AuthenticationDto;
import org.evomaster.client.java.controller.api.dto.CustomizedRequestValueDto;
import org.evomaster.client.java.controller.api.dto.JsonAuthRPCEndpointDto;
import org.evomaster.client.java.controller.api.dto.problem.rpc.RPCType;
import org.evomaster.client.java.controller.problem.rpc.CodeJavaGenerator;
import org.evomaster.client.java.controller.problem.rpc.CustomizedNotNullAnnotationForRPCDto;
import org.evomaster.client.java.controller.problem.rpc.JavaXConstraintHandler;
import org.evomaster.client.java.controller.problem.rpc.schema.EndpointSchema;
import org.evomaster.client.java.controller.problem.rpc.schema.InterfaceSchema;
import org.evomaster.client.java.controller.problem.rpc.schema.LocalAuthSetupSchema;
import org.evomaster.client.java.controller.problem.rpc.schema.params.ArrayParam;
import org.evomaster.client.java.controller.problem.rpc.schema.params.BigDecimalParam;
import org.evomaster.client.java.controller.problem.rpc.schema.params.BigIntegerParam;
import org.evomaster.client.java.controller.problem.rpc.schema.params.ByteBufferParam;
import org.evomaster.client.java.controller.problem.rpc.schema.params.DateParam;
import org.evomaster.client.java.controller.problem.rpc.schema.params.EnumParam;
import org.evomaster.client.java.controller.problem.rpc.schema.params.ListParam;
import org.evomaster.client.java.controller.problem.rpc.schema.params.MapParam;
import org.evomaster.client.java.controller.problem.rpc.schema.params.NamedTypedValue;
import org.evomaster.client.java.controller.problem.rpc.schema.params.ObjectParam;
import org.evomaster.client.java.controller.problem.rpc.schema.params.PairParam;
import org.evomaster.client.java.controller.problem.rpc.schema.params.PrimitiveOrWrapperParam;
import org.evomaster.client.java.controller.problem.rpc.schema.params.SetParam;
import org.evomaster.client.java.controller.problem.rpc.schema.params.StringParam;
import org.evomaster.client.java.controller.problem.rpc.schema.types.AccessibleSchema;
import org.evomaster.client.java.controller.problem.rpc.schema.types.BigDecimalType;
import org.evomaster.client.java.controller.problem.rpc.schema.types.BigIntegerType;
import org.evomaster.client.java.controller.problem.rpc.schema.types.CollectionType;
import org.evomaster.client.java.controller.problem.rpc.schema.types.CycleObjectType;
import org.evomaster.client.java.controller.problem.rpc.schema.types.EnumType;
import org.evomaster.client.java.controller.problem.rpc.schema.types.MapType;
import org.evomaster.client.java.controller.problem.rpc.schema.types.ObjectType;
import org.evomaster.client.java.controller.problem.rpc.schema.types.PairType;
import org.evomaster.client.java.controller.problem.rpc.schema.types.PrimitiveOrWrapperType;
import org.evomaster.client.java.controller.problem.rpc.schema.types.StringType;
import org.evomaster.client.java.controller.problem.rpc.schema.types.TypeSchema;
import org.evomaster.client.java.utils.SimpleLogger;
import shaded.com.fasterxml.jackson.core.JsonProcessingException;
import shaded.com.fasterxml.jackson.databind.JsonNode;
import shaded.com.fasterxml.jackson.databind.ObjectMapper;

public class RPCEndpointsBuilder {
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private static final String OBJECT_FLAG = "OBJECT";
    private static final String NATIVE_THRIFT_DTO_INTERFACE = "org.apache.thrift.TBase";
    private static final String NATIVE_THRIFT_FIELD_SCHEMA = "metaDataMap";

    private static String getObjectTypeNameWithFlag(Class<?> clazz, String name) {
        if (RPCEndpointsBuilder.isNotCustomizedObject(clazz)) {
            return name;
        }
        return "OBJECT:" + name;
    }

    private static boolean isNotCustomizedObject(Class<?> clazz) {
        return PrimitiveOrWrapperType.isPrimitiveOrTypes(clazz) || clazz == String.class || clazz == ByteBuffer.class || clazz.isEnum() || clazz.isArray() || List.class.isAssignableFrom(clazz) || Set.class.isAssignableFrom(clazz);
    }

    public static void validateCustomizedValueInRequests(List<CustomizedRequestValueDto> customizedRequestValueDtos) {
        if (customizedRequestValueDtos == null || customizedRequestValueDtos.isEmpty()) {
            return;
        }
        customizedRequestValueDtos.forEach(s -> {
            if (s.keyValues != null && s.combinedKeyValuePairs != null) {
                throw new IllegalArgumentException("Driver Config Error: keyValues and keyValuePairs should not be specified at the same time");
            }
            if (s.keyValues == null && s.combinedKeyValuePairs == null) {
                throw new IllegalArgumentException("Driver Config Error: one of keyValues and keyValuePairs must be specified, could not be null at the same time");
            }
        });
        RPCEndpointsBuilder.validateKeyValuePairs(customizedRequestValueDtos);
        RPCEndpointsBuilder.validateKeyValues(customizedRequestValueDtos);
    }

    public static void validateCustomizedNotNullAnnotationForRPCDto(List<CustomizedNotNullAnnotationForRPCDto> notNullAnnotations) {
        if (notNullAnnotations == null || notNullAnnotations.isEmpty()) {
            return;
        }
        notNullAnnotations.forEach(s -> {
            if (s.annotationType == null) {
                throw new IllegalArgumentException("Driver Config Error: annotationType should not be null");
            }
            if (s.annotationMethod == null ^ s.equalsTo == null) {
                throw new IllegalArgumentException("Driver Config Error: annotationMethod and equalsTo should be specified at the same time");
            }
        });
    }

    private static void validateKeyValues(List<CustomizedRequestValueDto> customizedRequestValueDtos) {
        ArrayList handled = new ArrayList();
        customizedRequestValueDtos.stream().filter(s -> s.keyValues != null).forEach(s -> {
            if (s.keyValues.key == null) {
                throw new IllegalArgumentException("Driver Config Error: key must be specified when customizing keyValues");
            }
            if (s.keyValues.values.isEmpty()) {
                throw new IllegalArgumentException("Driver Config Error: at least one values is needed for customizing keyValues with the key " + s.keyValues.key);
            }
            String key = "key:" + s.keyValues.key + "" + RPCEndpointsBuilder.getKeyForCustomizedRequestValueDto(s);
            if (handled.contains(key)) {
                throw new IllegalArgumentException("Driver Config Error: " + key + " should be specified only once");
            }
            handled.add(key);
        });
    }

    private static void validateKeyValuePairs(List<CustomizedRequestValueDto> customizedRequestValueDtos) {
        HashMap<String, List> group = new HashMap<String, List>();
        customizedRequestValueDtos.stream().filter(s -> s.combinedKeyValuePairs != null && !s.combinedKeyValuePairs.isEmpty()).forEach(s -> {
            String key = RPCEndpointsBuilder.getKeyForCustomizedRequestValueDto(s);
            if (key.length() != 0) {
                if (!group.containsKey(key)) {
                    group.put(key, new ArrayList());
                }
                ((List)group.get(key)).add(s);
            }
        });
        group.forEach((key, g) -> {
            if (g.size() > 1) {
                List keys = ((CustomizedRequestValueDto)g.get((int)0)).combinedKeyValuePairs.stream().map(a -> a.fieldKey).collect(Collectors.toList());
                g.forEach(a -> {
                    List akeys = a.combinedKeyValuePairs.stream().map(k -> k.fieldKey).collect(Collectors.toList());
                    if (akeys.size() != keys.size() || !akeys.containsAll(keys)) {
                        throw new IllegalArgumentException("Driver Config Error: keys for same " + key + " must be specified with same keys");
                    }
                });
            }
        });
    }

    private static String getKeyForCustomizedRequestValueDto(CustomizedRequestValueDto s) {
        String key = "";
        if (s.annotationOnEndpoint != null) {
            key = key + " annotationOnEndpoint_" + s.annotationOnEndpoint;
        }
        if (s.specificEndpointName != null) {
            key = key + " specificEndpointName_" + s.specificEndpointName;
        }
        if (s.specificRequestTypeName != null) {
            key = key + " specificRequestTypeName_" + s.specificRequestTypeName;
        }
        return key;
    }

    public static InterfaceSchema build(String interfaceName, RPCType rpcType, Object client, List<String> skipEndpointsByName, List<String> skipEndpointsByAnnotation, List<String> involveEndpointsByName, List<String> involveEndpointsByAnnotation, List<AuthenticationDto> authenticationDtoList, List<CustomizedRequestValueDto> customizedRequestValueDtos, List<CustomizedNotNullAnnotationForRPCDto> notNullAnnotations) {
        ArrayList<EndpointSchema> endpoints = new ArrayList<EndpointSchema>();
        ArrayList<EndpointSchema> endpointsForAuth = new ArrayList<EndpointSchema>();
        ArrayList<String> skippedEndpoints = new ArrayList<String>();
        HashMap<Integer, EndpointSchema> authEndpoints = new HashMap<Integer, EndpointSchema>();
        try {
            Class<?> interfaze = Class.forName(interfaceName);
            InterfaceSchema schema = new InterfaceSchema(interfaceName, endpoints, RPCEndpointsBuilder.getClientClass(client), rpcType, skippedEndpoints, authEndpoints, endpointsForAuth);
            for (Method m : interfaze.getDeclaredMethods()) {
                if (RPCEndpointsBuilder.filterMethod(m, skipEndpointsByName, skipEndpointsByAnnotation, involveEndpointsByName, involveEndpointsByAnnotation)) {
                    try {
                        EndpointSchema endpointSchema = RPCEndpointsBuilder.build(schema, m, rpcType, authenticationDtoList, customizedRequestValueDtos, notNullAnnotations);
                        endpoints.add(endpointSchema);
                    }
                    catch (RuntimeException exception) {
                        SimpleLogger.error("EM Driver Error: fail to handle the endpoint schema " + m.getName() + " with the error msg:" + exception.getMessage());
                    }
                } else {
                    skippedEndpoints.add(m.getName());
                }
                List<AuthenticationDto> auths = RPCEndpointsBuilder.getAuthEndpointInInterface(authenticationDtoList, interfaceName, m);
                if (auths == null || auths.isEmpty()) continue;
                try {
                    EndpointSchema authEndpoint = RPCEndpointsBuilder.build(schema, m, rpcType, null, customizedRequestValueDtos, notNullAnnotations);
                    endpointsForAuth.add(authEndpoint);
                    for (AuthenticationDto auth : auths) {
                        EndpointSchema copy = authEndpoint.copyStructure();
                        if (auth.jsonAuthEndpoint == null) {
                            throw new IllegalArgumentException("Driver Config Error: now we only support auth info specified with JsonAuthRPCEndpointDto");
                        }
                        int index = authenticationDtoList.indexOf(auth);
                        if (copy.getRequestParams().size() != auth.jsonAuthEndpoint.jsonPayloads.size()) {
                            throw new IllegalArgumentException("Driver Config Error: mismatched size of jsonPayloads (" + auth.jsonAuthEndpoint.classNames.size() + ") with real endpoint (" + authEndpoint.getRequestParams().size() + ").");
                        }
                        RPCEndpointsBuilder.setAuthEndpoint(copy, auth.jsonAuthEndpoint);
                        authEndpoints.put(index, copy);
                    }
                }
                catch (RuntimeException exception) {
                    SimpleLogger.error("EM Driver Error: fail to handle the authEndpoint schema " + m.getName() + " with the error msg:" + exception.getMessage());
                }
            }
            return schema;
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("cannot find the interface with the name (" + interfaceName + ") and the error message is " + e.getMessage());
        }
    }

    public static Map<Integer, LocalAuthSetupSchema> buildLocalAuthSetup(List<AuthenticationDto> authenticationDtoList) {
        if (authenticationDtoList == null || authenticationDtoList.isEmpty()) {
            return null;
        }
        HashMap<Integer, LocalAuthSetupSchema> map = new HashMap<Integer, LocalAuthSetupSchema>();
        for (AuthenticationDto dto : authenticationDtoList) {
            if (dto.localAuthSetup == null) continue;
            int index = authenticationDtoList.indexOf(dto);
            LocalAuthSetupSchema local = new LocalAuthSetupSchema();
            local.getRequestParams().get(0).setValueBasedOnInstance(dto.localAuthSetup.authenticationInfo);
            map.put(index, local);
        }
        return map;
    }

    private static void setAuthEndpoint(EndpointSchema authEndpoint, JsonAuthRPCEndpointDto jsonAuthEndpoint) throws ClassNotFoundException {
        if (jsonAuthEndpoint.classNames != null && jsonAuthEndpoint.classNames.size() != jsonAuthEndpoint.jsonPayloads.size()) {
            throw new IllegalArgumentException("Driver Config Error: to specify inputs for auth endpoint, classNames and jsonPayloads should have same size");
        }
        for (int i = 0; i < authEndpoint.getRequestParams().size(); ++i) {
            NamedTypedValue inputParam = authEndpoint.getRequestParams().get(i);
            String jsonString = jsonAuthEndpoint.jsonPayloads.get(i);
            if (jsonAuthEndpoint.classNames == null) {
                RPCEndpointsBuilder.setNamedValueBasedOnJsonString(inputParam, jsonString, i);
                continue;
            }
            Class<?> clazz = Class.forName(jsonAuthEndpoint.classNames.get(i));
            try {
                Object value = objectMapper.readValue(jsonString, clazz);
                inputParam.setValueBasedOnInstance(value);
                continue;
            }
            catch (JsonProcessingException e) {
                SimpleLogger.uniqueWarn("Driver Config Error: a jsonPayload at (" + i + ") cannot be read as the object " + jsonAuthEndpoint.classNames.get(i));
                RPCEndpointsBuilder.setNamedValueBasedOnJsonString(inputParam, jsonString, i);
            }
        }
    }

    private static void setNamedValueBasedOnJsonString(NamedTypedValue inputParam, String jsonString, int index) {
        if (inputParam instanceof StringParam || inputParam instanceof PrimitiveOrWrapperParam || inputParam instanceof ByteBufferParam) {
            RPCEndpointsBuilder.setNamedValueBasedOnCandidates(inputParam, jsonString);
        } else if (inputParam instanceof ObjectParam) {
            try {
                JsonNode node = objectMapper.readTree(jsonString);
                ArrayList fields = new ArrayList();
                for (NamedTypedValue f : ((ObjectType)((ObjectParam)inputParam).getType()).getFields()) {
                    NamedTypedValue v = f.copyStructureWithProperties();
                    if (node.has(v.getName())) {
                        RPCEndpointsBuilder.setNamedValueBasedOnCandidates(f, node.textValue());
                        fields.add(v);
                        continue;
                    }
                    SimpleLogger.uniqueWarn("Driver Config Error: cannot find field with the name " + v.getName() + " in the specified json");
                }
                inputParam.setValue(fields);
            }
            catch (JsonProcessingException ex) {
                SimpleLogger.uniqueWarn("Driver Config Error: a jsonPayload at (" + index + ") cannot be read as a JSON object with error:" + ex.getMessage());
            }
        }
    }

    private static List<AuthenticationDto> getAuthEndpointInInterface(List<AuthenticationDto> authenticationDtos, String interfaceName, Method method) {
        if (authenticationDtos == null) {
            return null;
        }
        for (AuthenticationDto dto : authenticationDtos) {
            if (dto.localAuthSetup != null || dto.jsonAuthEndpoint != null && dto.jsonAuthEndpoint.endpointName != null && dto.jsonAuthEndpoint.interfaceName != null) continue;
            SimpleLogger.uniqueWarn("Driver Config Error: To specify auth for RPC, either localAuthSetup or jsonAuthEndpoint should be specified.For JsonAuthRPCEndpointDto, endpointName and interfaceName cannot be null");
        }
        return authenticationDtos.stream().filter(a -> a.jsonAuthEndpoint != null && a.jsonAuthEndpoint.endpointName.equals(method.getName()) && a.jsonAuthEndpoint.interfaceName.equals(interfaceName)).collect(Collectors.toList());
    }

    private static boolean filterMethod(Method endpoint, List<String> skipEndpointsByName, List<String> skipEndpointsByAnnotation, List<String> involveEndpointsByName, List<String> involveEndpointsByAnnotation) {
        if (skipEndpointsByName != null && involveEndpointsByName != null) {
            throw new IllegalArgumentException("Driver Config Error: skipEndpointsByName and involveEndpointsByName should not be specified at same time.");
        }
        if (skipEndpointsByAnnotation != null && involveEndpointsByAnnotation != null) {
            throw new IllegalArgumentException("Driver Config Error: skipEndpointsByAnnotation and involveEndpointsByAnnotation should not be specified at same time.");
        }
        if (skipEndpointsByName != null || skipEndpointsByAnnotation != null) {
            return !RPCEndpointsBuilder.anyMatchByNameAndAnnotation(endpoint, skipEndpointsByName, skipEndpointsByAnnotation);
        }
        if (involveEndpointsByName != null || involveEndpointsByAnnotation != null) {
            return RPCEndpointsBuilder.anyMatchByNameAndAnnotation(endpoint, involveEndpointsByName, involveEndpointsByAnnotation);
        }
        return true;
    }

    private static boolean anyMatchByNameAndAnnotation(Method endpoint, List<String> names, List<String> annotations) {
        boolean anyMatch = false;
        if (annotations != null) {
            for (Annotation annotation : endpoint.getAnnotations()) {
                anyMatch = anyMatch || annotations.contains(annotation.annotationType().getName());
            }
        }
        if (names != null) {
            anyMatch = anyMatch || names.contains(endpoint.getName());
        }
        return anyMatch;
    }

    private static String getClientClass(Object client) {
        if (client == null) {
            return null;
        }
        String clazzType = client.getClass().getName();
        if (!clazzType.startsWith("com.sun.proxy.")) {
            return clazzType;
        }
        Class<?>[] clazz = client.getClass().getInterfaces();
        if (clazz.length == 0) {
            SimpleLogger.error("Error: the client is not related to any interface");
            return null;
        }
        if (clazz.length > 1) {
            SimpleLogger.error("ERROR: the client has more than one interfaces");
        }
        return clazz[0].getName();
    }

    private static EndpointSchema build(InterfaceSchema schema, Method method, RPCType rpcType, List<AuthenticationDto> authenticationDtoList, List<CustomizedRequestValueDto> customizedRequestValueDtos, List<CustomizedNotNullAnnotationForRPCDto> notNullAnnotations) {
        ArrayList<NamedTypedValue> requestParams = new ArrayList<NamedTypedValue>();
        List<AuthenticationDto> authAnnotationDtos = RPCEndpointsBuilder.getSpecificRelatedAuth(authenticationDtoList, method);
        List<Integer> authKeys = null;
        if (authAnnotationDtos != null) {
            authKeys = authAnnotationDtos.stream().map(s -> authenticationDtoList.indexOf(s)).collect(Collectors.toList());
        }
        HashSet<String> relatedCustomization = new HashSet<String>();
        for (Parameter p : method.getParameters()) {
            requestParams.add(RPCEndpointsBuilder.buildInputParameter(schema, p, rpcType, RPCEndpointsBuilder.getRelatedCustomization(customizedRequestValueDtos, method), relatedCustomization, notNullAnnotations));
        }
        NamedTypedValue response = null;
        if (!method.getReturnType().equals(Void.TYPE)) {
            HashMap<TypeVariable, Type> genericTypeMap = new HashMap<TypeVariable, Type>();
            response = RPCEndpointsBuilder.build(schema, method.getReturnType(), method.getGenericReturnType(), "return", rpcType, new ArrayList<String>(), null, null, null, null, null, genericTypeMap);
        }
        ArrayList<NamedTypedValue> exceptions = null;
        if (method.getExceptionTypes().length > 0) {
            exceptions = new ArrayList<NamedTypedValue>();
            for (int i = 0; i < method.getExceptionTypes().length; ++i) {
                NamedTypedValue exception = RPCEndpointsBuilder.build(schema, method.getExceptionTypes()[i], method.getGenericExceptionTypes()[i], "exception_" + i, rpcType, new ArrayList<String>(), null, null, null, null, null, null);
                exceptions.add(exception);
            }
        }
        return new EndpointSchema(method.getName(), schema.getName(), schema.getClientInfo(), requestParams, response, exceptions, authAnnotationDtos != null && !authAnnotationDtos.isEmpty(), authKeys, relatedCustomization);
    }

    private static List<AuthenticationDto> getSpecificRelatedAuth(List<AuthenticationDto> authenticationDtoList, Method method) {
        if (authenticationDtoList == null) {
            return null;
        }
        List annotations = Arrays.stream(method.getAnnotations()).map(s -> s.annotationType().getName()).collect(Collectors.toList());
        return authenticationDtoList.stream().filter(s -> s.localAuthSetup != null && s.localAuthSetup.annotationOnEndpoint != null && annotations.contains(s.localAuthSetup.annotationOnEndpoint) || s.jsonAuthEndpoint != null && s.jsonAuthEndpoint.annotationOnEndpoint != null && annotations.contains(s.jsonAuthEndpoint.annotationOnEndpoint)).collect(Collectors.toList());
    }

    private static Map<Integer, CustomizedRequestValueDto> getRelatedCustomization(List<CustomizedRequestValueDto> customizedRequestValueDtos, Method method) {
        if (customizedRequestValueDtos == null) {
            return null;
        }
        List annotations = Arrays.stream(method.getAnnotations()).map(s -> s.annotationType().getName()).collect(Collectors.toList());
        List<CustomizedRequestValueDto> list = customizedRequestValueDtos.stream().filter(s -> !(s.annotationOnEndpoint != null && !annotations.contains(s.annotationOnEndpoint) || s.specificEndpointName != null && !s.specificEndpointName.contains(method.getName()))).collect(Collectors.toList());
        if (list.isEmpty()) {
            return null;
        }
        HashMap<Integer, CustomizedRequestValueDto> map = new HashMap<Integer, CustomizedRequestValueDto>();
        list.forEach(s -> map.put(customizedRequestValueDtos.indexOf(s), (CustomizedRequestValueDto)s));
        return map;
    }

    private static NamedTypedValue buildInputParameter(InterfaceSchema schema, Parameter parameter, RPCType type, Map<Integer, CustomizedRequestValueDto> customizationDtos, Set<String> relatedCustomization, List<CustomizedNotNullAnnotationForRPCDto> notNullAnnotations) {
        String name = parameter.getName();
        Class<?> clazz = parameter.getType();
        ArrayList<String> depth = new ArrayList<String>();
        HashMap<TypeVariable, Type> genericTypeMap = new HashMap<TypeVariable, Type>();
        NamedTypedValue namedTypedValue = RPCEndpointsBuilder.build(schema, clazz, parameter.getParameterizedType(), name, type, depth, customizationDtos, relatedCustomization, null, notNullAnnotations, null, genericTypeMap);
        for (Annotation annotation : parameter.getAnnotations()) {
            RPCEndpointsBuilder.handleConstraint(namedTypedValue, annotation, notNullAnnotations);
        }
        return namedTypedValue;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static NamedTypedValue build(InterfaceSchema schema, Class<?> clazz, Type genericType, String name, RPCType rpcType, List<String> depth, Map<Integer, CustomizedRequestValueDto> customizationDtos, Set<String> relatedCustomization, AccessibleSchema accessibleSchema, List<CustomizedNotNullAnnotationForRPCDto> notNullAnnotations, Class<?> originalType, Map<TypeVariable, Type> genericTypeMap) {
        void var14_30;
        RPCEndpointsBuilder.handleGenericSuperclass(clazz, genericTypeMap);
        List<String> genericTypes = RPCEndpointsBuilder.handleGenericType(clazz, genericType, genericTypeMap);
        String clazzWithGenericTypes = CodeJavaGenerator.handleClassNameWithGeneric(clazz.getName(), genericTypes);
        depth.add(RPCEndpointsBuilder.getObjectTypeNameWithFlag(clazz, clazzWithGenericTypes));
        Object var14_14 = null;
        try {
            if (PrimitiveOrWrapperType.isPrimitiveOrTypes(clazz)) {
                PrimitiveOrWrapperParam primitiveOrWrapperParam = PrimitiveOrWrapperParam.build(name, clazz, accessibleSchema);
            } else if (clazz == String.class) {
                StringType stringType = new StringType();
                StringParam stringParam = new StringParam(name, stringType, accessibleSchema);
            } else if (clazz == BigDecimal.class) {
                BigDecimalType bigDecimalType = new BigDecimalType();
                BigDecimalParam bigDecimalParam = new BigDecimalParam(name, bigDecimalType, accessibleSchema);
            } else if (clazz == BigInteger.class) {
                BigIntegerType bigIntegerType = new BigIntegerType();
                BigIntegerParam bigIntegerParam = new BigIntegerParam(name, bigIntegerType, accessibleSchema);
            } else if (clazz.isEnum()) {
                String[] items = (String[])Arrays.stream(clazz.getEnumConstants()).map(e -> RPCEndpointsBuilder.getNameEnumConstant(e)).toArray(String[]::new);
                EnumType enumType = new EnumType(clazz.getSimpleName(), clazz.getName(), items, clazz);
                EnumParam param = new EnumParam(name, enumType, accessibleSchema);
                schema.registerType(enumType.copy(), param.copyStructureWithProperties());
                EnumParam enumParam = param;
            } else if (clazz.isArray()) {
                Type type = null;
                Class<?> templateClazz = null;
                if (genericType instanceof GenericArrayType) {
                    type = ((GenericArrayType)genericType).getGenericComponentType();
                    templateClazz = RPCEndpointsBuilder.getTemplateClass(type, genericTypeMap);
                } else {
                    templateClazz = clazz.getComponentType();
                }
                NamedTypedValue template = RPCEndpointsBuilder.build(schema, templateClazz, type, "template", rpcType, depth, customizationDtos, relatedCustomization, null, notNullAnnotations, null, genericTypeMap);
                template.setNullable(false);
                CollectionType ctype = new CollectionType(clazz.getSimpleName(), clazz.getName(), template, clazz);
                ctype.depth = RPCEndpointsBuilder.getDepthLevel(clazz, depth, clazzWithGenericTypes);
                ArrayParam arrayParam = new ArrayParam(name, ctype, accessibleSchema);
            } else if (clazz == ByteBuffer.class) {
                ByteBufferParam byteBufferParam = new ByteBufferParam(name, accessibleSchema);
            } else if (List.class.isAssignableFrom(clazz) || Set.class.isAssignableFrom(clazz)) {
                if (genericType == null) {
                    throw new RuntimeException("genericType should not be null for List and Set class");
                }
                Type type = ((ParameterizedType)genericType).getActualTypeArguments()[0];
                Class<?> templateClazz = RPCEndpointsBuilder.getTemplateClass(type, genericTypeMap);
                NamedTypedValue template = RPCEndpointsBuilder.build(schema, templateClazz, type, "template", rpcType, depth, customizationDtos, relatedCustomization, null, notNullAnnotations, null, genericTypeMap);
                template.setNullable(false);
                CollectionType ctype = new CollectionType(clazz.getSimpleName(), clazz.getName(), template, clazz);
                ctype.depth = RPCEndpointsBuilder.getDepthLevel(clazz, depth, clazzWithGenericTypes);
                if (List.class.isAssignableFrom(clazz)) {
                    ListParam listParam = new ListParam(name, ctype, accessibleSchema);
                } else {
                    SetParam setParam = new SetParam(name, ctype, accessibleSchema);
                }
            } else if (Map.class.isAssignableFrom(clazz)) {
                if (genericType == null) {
                    throw new RuntimeException("genericType should not be null for List and Set class");
                }
                Type keyType = ((ParameterizedType)genericType).getActualTypeArguments()[0];
                Type valueType = ((ParameterizedType)genericType).getActualTypeArguments()[1];
                Class<?> keyTemplateClazz = RPCEndpointsBuilder.getTemplateClass(keyType, genericTypeMap);
                NamedTypedValue keyTemplate = RPCEndpointsBuilder.build(schema, keyTemplateClazz, keyType, "keyTemplate", rpcType, depth, customizationDtos, relatedCustomization, null, notNullAnnotations, null, genericTypeMap);
                keyTemplate.setNullable(false);
                Class<?> valueTemplateClazz = RPCEndpointsBuilder.getTemplateClass(valueType, genericTypeMap);
                NamedTypedValue valueTemplate = RPCEndpointsBuilder.build(schema, valueTemplateClazz, valueType, "valueTemplate", rpcType, depth, customizationDtos, relatedCustomization, null, notNullAnnotations, null, genericTypeMap);
                MapType mtype = new MapType(clazz.getSimpleName(), clazz.getName(), new PairParam(new PairType(keyTemplate, valueTemplate), null), clazz);
                mtype.depth = RPCEndpointsBuilder.getDepthLevel(clazz, depth, clazzWithGenericTypes);
                MapParam mapParam = new MapParam(name, mtype, accessibleSchema);
            } else if (Date.class.isAssignableFrom(clazz)) {
                if (clazz != Date.class) throw new RuntimeException("NOT support " + clazz.getName() + " date type in java yet");
                DateParam dateParam = new DateParam(name, accessibleSchema);
            } else if (Exception.class.isAssignableFrom(clazz) && clazz.getName().startsWith("java")) {
                StringParam msgField = new StringParam("message", new AccessibleSchema(false, null, "getMessage"));
                ObjectType exceptionType = new ObjectType(clazz.getSimpleName(), clazz.getName(), Collections.singletonList(msgField), clazz, genericTypes);
                ObjectParam objectParam = new ObjectParam(name, exceptionType, accessibleSchema);
            } else {
                if (clazz.getName().startsWith("java")) {
                    throw new RuntimeException("NOT handle " + clazz.getName() + " class in java yet");
                }
                long cycleSize = depth.stream().filter(s -> s.equals(RPCEndpointsBuilder.getObjectTypeNameWithFlag(clazz, clazzWithGenericTypes))).count();
                if (cycleSize == 1L) {
                    ArrayList<NamedTypedValue> fields = new ArrayList<NamedTypedValue>();
                    Map<Integer, CustomizedRequestValueDto> objRelatedCustomizationDtos = RPCEndpointsBuilder.getCustomizationBasedOnSpecifiedType(customizationDtos, clazz.getName());
                    ArrayList<Field> fieldList = new ArrayList<Field>();
                    RPCEndpointsBuilder.getAllFields(clazz, fieldList, rpcType);
                    for (Field f : fieldList) {
                        if (Modifier.isFinal(f.getModifiers()) || RPCEndpointsBuilder.doSkipReflection(f.getName())) continue;
                        AccessibleSchema faccessSchema = null;
                        if (Modifier.isPublic(f.getModifiers())) {
                            faccessSchema = new AccessibleSchema();
                        } else {
                            faccessSchema = new AccessibleSchema(false, RPCEndpointsBuilder.findGetterOrSetter(clazz, f, false), RPCEndpointsBuilder.findGetterOrSetter(clazz, f, true));
                            if (faccessSchema.getterMethodName == null || faccessSchema.setterMethodName == null) {
                                SimpleLogger.warn("Error: skip the field " + f.getName() + " since its setter/getter is not found");
                                continue;
                            }
                        }
                        Class fType = f.getType();
                        Class<?> foriginalType = null;
                        Type fGType = f.getGenericType();
                        if (f.getGenericType() instanceof TypeVariable) {
                            foriginalType = f.getType();
                            Type actualType = RPCEndpointsBuilder.getActualType(genericTypeMap, (TypeVariable)f.getGenericType());
                            if (actualType instanceof Class) {
                                fType = (Class)actualType;
                                fGType = fType;
                            } else if (actualType instanceof ParameterizedType) {
                                fGType = actualType;
                                if (!(((ParameterizedType)actualType).getRawType() instanceof Class)) throw new RuntimeException("Error: Fail to handle actual type of a generic type");
                                fType = (Class)((ParameterizedType)actualType).getRawType();
                            }
                        }
                        NamedTypedValue field = RPCEndpointsBuilder.build(schema, fType, fGType, f.getName(), rpcType, depth, objRelatedCustomizationDtos, relatedCustomization, faccessSchema, notNullAnnotations, foriginalType, genericTypeMap);
                        for (Annotation annotation : f.getAnnotations()) {
                            RPCEndpointsBuilder.handleConstraint(field, annotation, notNullAnnotations);
                        }
                        fields.add(field);
                    }
                    RPCEndpointsBuilder.handleNativeRPCConstraints(clazz, fields, rpcType);
                    ObjectType otype = new ObjectType(clazz.getSimpleName(), clazz.getName(), fields, clazz, genericTypes);
                    otype.setOriginalType(originalType);
                    otype.depth = RPCEndpointsBuilder.getDepthLevel(clazz, depth, clazzWithGenericTypes);
                    ObjectParam oparam = new ObjectParam(name, otype, accessibleSchema);
                    schema.registerType(otype.copy(), oparam);
                    ObjectParam objectParam = oparam;
                } else {
                    CycleObjectType otype = new CycleObjectType(clazz.getSimpleName(), clazz.getName(), clazz, genericTypes);
                    otype.depth = RPCEndpointsBuilder.getDepthLevel(clazz, depth, clazzWithGenericTypes);
                    ObjectParam oparam = new ObjectParam(name, otype, accessibleSchema);
                    schema.registerType(otype.copy(), oparam);
                    ObjectParam objectParam = oparam;
                }
            }
        }
        catch (ClassCastException e2) {
            throw new RuntimeException(String.format("fail to perform reflection on param/field: %s; class: %s; genericType: %s; class of genericType: %s; depth: %s; error info:%s", name, clazz.getName(), genericType == null ? "null" : genericType.getTypeName(), genericType == null ? "null" : genericType.getClass().getName(), String.join((CharSequence)",", depth), e2.getMessage()));
        }
        ((TypeSchema)var14_30.getType()).setOriginalType(originalType);
        if (customizationDtos == null) return var14_30;
        RPCEndpointsBuilder.handleNamedValueWithCustomizedDto((NamedTypedValue)var14_30, customizationDtos, relatedCustomization);
        return var14_30;
    }

    private static String getNameEnumConstant(Object object) {
        try {
            Method name = object.getClass().getMethod("name", new Class[0]);
            name.setAccessible(true);
            return (String)name.invoke(object, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            SimpleLogger.warn("Driver Error: fail to extract name for enum constant", e);
            return object.toString();
        }
    }

    private static void handleGenericSuperclass(Class clazz, Map<TypeVariable, Type> map) {
        if (RPCEndpointsBuilder.isNotCustomizedObject(clazz)) {
            return;
        }
        if (clazz.getGenericSuperclass() == null || !(clazz.getGenericSuperclass() instanceof ParameterizedType)) {
            return;
        }
        Type[] actualTypes = ((ParameterizedType)clazz.getGenericSuperclass()).getActualTypeArguments();
        if (((ParameterizedType)clazz.getGenericSuperclass()).getActualTypeArguments().length == 0) {
            return;
        }
        TypeVariable<Class<T>>[] typeVariables = clazz.getSuperclass().getTypeParameters();
        if (typeVariables.length != actualTypes.length) {
            throw new RuntimeException("Error: fail to handle generic types in Dto");
        }
        for (int i = 0; i < typeVariables.length; ++i) {
            map.put(typeVariables[i], actualTypes[i]);
        }
        RPCEndpointsBuilder.handleGenericSuperclass(clazz.getSuperclass(), map);
    }

    private static List<String> handleGenericType(Class<?> clazz, Type genericType, Map<TypeVariable, Type> map) {
        if (RPCEndpointsBuilder.isNotCustomizedObject(clazz)) {
            return null;
        }
        if (!(genericType instanceof ParameterizedType)) {
            return null;
        }
        ArrayList<String> genericTypes = new ArrayList<String>();
        Type[] actualTypes = ((ParameterizedType)genericType).getActualTypeArguments();
        TypeVariable<Class<?>>[] typeVariables = clazz.getTypeParameters();
        if (typeVariables.length != actualTypes.length) {
            throw new RuntimeException("Error: fail to handle generic types in Dto");
        }
        for (int i = 0; i < typeVariables.length; ++i) {
            Type a = actualTypes[i];
            if (a instanceof TypeVariable) {
                a = RPCEndpointsBuilder.getActualType(map, (TypeVariable)a);
            }
            if (a != null) {
                genericTypes.add(a.getTypeName());
            }
            map.put(typeVariables[i], actualTypes[i]);
        }
        return genericTypes;
    }

    private static Type getActualType(Map<TypeVariable, Type> map, TypeVariable typeVariable) {
        Type t = map.get(typeVariable);
        if (t == null) {
            return null;
        }
        if (t instanceof TypeVariable) {
            return RPCEndpointsBuilder.getActualType(map, (TypeVariable)t);
        }
        return t;
    }

    private static void getAllFields(Class<?> clazz, List<Field> fieldList, RPCType type) {
        if (RPCEndpointsBuilder.isNativeThriftDto(clazz)) {
            RPCEndpointsBuilder.getFieldForNativeThriftDto(clazz, fieldList);
            return;
        }
        fieldList.addAll(0, Arrays.asList(clazz.getDeclaredFields()));
        if (!Exception.class.isAssignableFrom(clazz) && clazz.getSuperclass() != null && clazz.getSuperclass() != Object.class) {
            RPCEndpointsBuilder.getAllFields(clazz.getSuperclass(), fieldList, type);
        }
    }

    private static Map<Integer, CustomizedRequestValueDto> getCustomizationBasedOnSpecifiedType(Map<Integer, CustomizedRequestValueDto> customizationDtos, String objTypeName) {
        if (customizationDtos == null) {
            return null;
        }
        return customizationDtos.entrySet().stream().filter(s -> ((CustomizedRequestValueDto)s.getValue()).specificRequestTypeName == null || ((CustomizedRequestValueDto)s.getValue()).specificRequestTypeName.equals(objTypeName)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private static String findGetterOrSetter(Class<?> clazz, Field field, boolean findGetter) {
        List found = findGetter ? Arrays.stream(clazz.getMethods()).filter(m -> Modifier.isPublic(m.getModifiers()) && RPCEndpointsBuilder.isGetter(field.getName(), m.getName(), field.getType().getTypeName()) && m.getParameterCount() == 0).collect(Collectors.toList()) : Arrays.stream(clazz.getMethods()).filter(m -> Modifier.isPublic(m.getModifiers()) && RPCEndpointsBuilder.isSetter(field.getName(), m.getName(), field.getType().getTypeName()) && m.getParameterCount() == 1 && (m.getParameterTypes()[0].equals(field.getType()) || m.getParameterTypes()[0].equals(PrimitiveOrWrapperParam.getPrimitiveOrWrapper(field.getType())))).collect(Collectors.toList());
        if (found.size() == 1) {
            return ((Method)found.get(0)).getName();
        }
        String msg = "RPC extract schema Error: cannot access field property, there exist " + found.size() + " methods to access the field " + field.getName() + " for the class " + clazz.getName();
        if (found.size() > 1) {
            SimpleLogger.uniqueWarn(msg);
            return ((Method)found.get(0)).getName();
        }
        SimpleLogger.uniqueWarn(msg);
        return null;
    }

    private static boolean isSetter(String fieldName, String methodName, String type) {
        String gsMethod;
        boolean isBoolean = type.equals(Boolean.class.getName()) || type.equals(Boolean.TYPE.getName());
        String fieldText = fieldName;
        if (isBoolean && fieldText.startsWith("is") && fieldText.length() > 2) {
            fieldText = fieldText.substring(2);
        }
        return methodName.equalsIgnoreCase((gsMethod = "set") + fieldText) || methodName.equalsIgnoreCase(gsMethod + fieldName);
    }

    private static boolean isGetter(String fieldName, String methodName, String type) {
        boolean isBoolean = type.equals(Boolean.class.getName()) || type.equals(Boolean.TYPE.getName());
        return methodName.equalsIgnoreCase("get" + fieldName) || isBoolean && (methodName.equalsIgnoreCase(fieldName) || methodName.equalsIgnoreCase("is" + fieldName));
    }

    private static void handleNamedValueWithCustomizedDto(NamedTypedValue namedTypedValue, Map<Integer, CustomizedRequestValueDto> customizationDtos, Set<String> relatedCustomization) {
        ArrayList<String> candidateReferences = new ArrayList<String>();
        ArrayList<NamedTypedValue> candidates = new ArrayList<NamedTypedValue>();
        customizationDtos.forEach((i, dto) -> {
            if (dto.combinedKeyValuePairs != null) {
                dto.combinedKeyValuePairs.forEach(p -> {
                    NamedTypedValue copy;
                    boolean ok;
                    if (p.fieldKey.equals(namedTypedValue.getName()) && (ok = RPCEndpointsBuilder.setNamedValueBasedOnCandidates(copy = namedTypedValue.copyStructureWithProperties(), p.fieldValue))) {
                        if (!candidateReferences.contains("" + i)) {
                            relatedCustomization.add("" + i);
                            candidateReferences.add("" + i);
                            candidates.add(copy);
                        } else {
                            throw new IllegalArgumentException("Error: there should not exist same key with the name " + p.fieldKey + "in a combinedKeyValuePairs");
                        }
                    }
                });
            }
        });
        if (!candidates.isEmpty()) {
            namedTypedValue.setCandidateReferences(candidateReferences);
            namedTypedValue.setCandidates(candidates);
            return;
        }
        List ikey = customizationDtos.values().stream().filter(s -> s.keyValues != null && s.keyValues.key.equals(namedTypedValue.getName())).collect(Collectors.toList());
        if (ikey.size() == 1) {
            RPCEndpointsBuilder.setCandidatesForNamedValue(namedTypedValue, (CustomizedRequestValueDto)ikey.get(0));
        } else if (ikey.size() > 1) {
            throw new IllegalStateException("Error: more than one Dto for independent key with " + RPCEndpointsBuilder.getKeyForCustomizedRequestValueDto((CustomizedRequestValueDto)ikey.get(0)));
        }
    }

    private static void setCandidatesForNamedValue(NamedTypedValue namedTypedValue, CustomizedRequestValueDto customizedRequestValueDto) {
        boolean handled = true;
        ArrayList<NamedTypedValue> candidates = new ArrayList<NamedTypedValue>();
        if (namedTypedValue instanceof PrimitiveOrWrapperParam || namedTypedValue instanceof StringParam || namedTypedValue instanceof ByteBufferParam) {
            for (String v : customizedRequestValueDto.keyValues.values) {
                NamedTypedValue copy = namedTypedValue.copyStructureWithProperties();
                handled = handled && RPCEndpointsBuilder.setNamedValueBasedOnCandidates(copy, v);
                candidates.add(copy);
            }
        } else {
            SimpleLogger.uniqueWarn("Error: Do not support configuring pre-defined values for the type " + ((TypeSchema)namedTypedValue.getType()).getFullTypeName());
            return;
        }
        if (handled) {
            namedTypedValue.setCandidates(candidates);
        }
    }

    private static boolean setNamedValueBasedOnCandidates(NamedTypedValue copy, String value) {
        try {
            if (copy instanceof PrimitiveOrWrapperParam) {
                ((PrimitiveOrWrapperParam)copy).setValueBasedOnStringValue(value);
            } else if (copy instanceof StringParam) {
                copy.setValue(value);
            } else if (copy instanceof ByteBufferParam) {
                copy.setValue(value.getBytes());
            }
        }
        catch (RuntimeException exception) {
            SimpleLogger.uniqueWarn("Error: fail to generate candidates with string value " + value + " for " + copy.getName() + " with type " + ((TypeSchema)copy.getType()).getFullTypeName());
            return false;
        }
        return true;
    }

    private static void handleConstraint(NamedTypedValue namedTypedValue, Annotation annotation, List<CustomizedNotNullAnnotationForRPCDto> notNullAnnotations) {
        if (annotation.annotationType().getName().startsWith("javax.validation.constraints")) {
            JavaXConstraintHandler.handleParam(namedTypedValue, annotation);
        } else if (notNullAnnotations != null && !notNullAnnotations.isEmpty()) {
            boolean isRequired = notNullAnnotations.stream().anyMatch(a -> RPCEndpointsBuilder.isRequired(annotation, a));
            namedTypedValue.setNullable(!isRequired);
        }
    }

    private static boolean isRequired(Annotation annotation, CustomizedNotNullAnnotationForRPCDto notNullAnnotations) {
        if (annotation.annotationType().getName().equals(notNullAnnotations.annotationType)) {
            if (notNullAnnotations.annotationMethod != null && notNullAnnotations.equalsTo != null) {
                try {
                    return annotation.annotationType().getDeclaredMethod(notNullAnnotations.annotationMethod, new Class[0]).invoke((Object)annotation, new Object[0]).equals(notNullAnnotations.equalsTo);
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                    SimpleLogger.uniqueWarn("Error: fail to invoke the specified method in the annotation with the error msg:" + e.getMessage());
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    private static Class<?> getTemplateClass(Type type, Map<TypeVariable, Type> genericTypeMap) {
        Type actualType = type;
        if (type instanceof TypeVariable) {
            actualType = RPCEndpointsBuilder.getActualType(genericTypeMap, (TypeVariable)type);
        }
        if (actualType instanceof ParameterizedType) {
            return (Class)((ParameterizedType)actualType).getRawType();
        }
        if (actualType instanceof Class) {
            return (Class)actualType;
        }
        throw new RuntimeException("unhanded type:" + type);
    }

    private static boolean doSkipReflection(String name) {
        return name.equals("$jacocoData");
    }

    private static boolean isMetaMap(Field field) {
        boolean result;
        boolean bl = result = field.getName().equals(NATIVE_THRIFT_FIELD_SCHEMA) && Map.class.isAssignableFrom(field.getType());
        if (!result) {
            return result;
        }
        Type genericType = field.getGenericType();
        Type valueType = ((ParameterizedType)genericType).getActualTypeArguments()[1];
        return valueType.getTypeName().equals("org.apache.thrift.meta_data.FieldMetaData");
    }

    private static boolean isNativeThriftDto(Class<?> clazz) {
        return clazz.getInterfaces().length > 0 && Arrays.stream(clazz.getInterfaces()).anyMatch(i -> i.getName().equals(NATIVE_THRIFT_DTO_INTERFACE));
    }

    private static void getFieldForNativeThriftDto(Class<?> clazz, List<Field> fields) {
        try {
            Object metaMap;
            Field metaMap_field = clazz.getDeclaredField(NATIVE_THRIFT_FIELD_SCHEMA);
            if (RPCEndpointsBuilder.isMetaMap(metaMap_field) && (metaMap = metaMap_field.get(null)) instanceof Map) {
                for (Object f : ((Map)metaMap).values()) {
                    Field fname = f.getClass().getDeclaredField("fieldName");
                    fname.setAccessible(true);
                    String name = (String)fname.get(f);
                    fields.add(clazz.getDeclaredField(name));
                }
            }
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            SimpleLogger.uniqueWarn("Error: fail to get the metaDataMap field in native dto");
        }
    }

    private static void handleNativeRPCConstraints(Class<?> clazz, List<NamedTypedValue> fields, RPCType type) {
        if (RPCEndpointsBuilder.isNativeThriftDto(clazz)) {
            try {
                Field metaMap_field = clazz.getDeclaredField(NATIVE_THRIFT_FIELD_SCHEMA);
                if (RPCEndpointsBuilder.isMetaMap(metaMap_field)) {
                    RPCEndpointsBuilder.handleMetaMap(metaMap_field, fields);
                }
            }
            catch (NoSuchFieldException e) {
                SimpleLogger.uniqueWarn("Error: fail to get the metaDataMap field in native dto");
            }
        }
    }

    private static void handleMetaMap(Field metaMap_field, List<NamedTypedValue> fields) {
        Object metaMap = null;
        try {
            metaMap = metaMap_field.get(null);
            if (metaMap instanceof Map) {
                for (Object f : ((Map)metaMap).values()) {
                    Field fname = f.getClass().getDeclaredField("fieldName");
                    fname.setAccessible(true);
                    String name = (String)fname.get(f);
                    NamedTypedValue field = RPCEndpointsBuilder.findFieldByName(name, fields);
                    if (field != null) {
                        Field frequiredType = f.getClass().getDeclaredField("requirementType");
                        frequiredType.setAccessible(true);
                        byte required = (Byte)frequiredType.get(f);
                        if (required != 1) continue;
                        field.setNullable(false);
                        continue;
                    }
                    SimpleLogger.uniqueWarn("Error: fail to find field in list but exist in metaMap, and the field name is " + name);
                }
            }
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            SimpleLogger.uniqueWarn("Error: fail to set isNull based on metaMap of Thrift struct " + e.getMessage());
        }
    }

    private static NamedTypedValue findFieldByName(String name, List<NamedTypedValue> fields) {
        for (NamedTypedValue f : fields) {
            if (!f.getName().equals(name)) continue;
            return f;
        }
        return null;
    }

    private static int getDepthLevel(Class clazz, List<String> depth, String clazzFullNameWithGeneric) {
        String tag = RPCEndpointsBuilder.getObjectTypeNameWithFlag(clazz, clazzFullNameWithGeneric);
        int start = Math.max(0, depth.lastIndexOf(tag));
        return depth.subList(start, depth.size()).stream().filter(s -> !s.equals(tag) && s.startsWith(OBJECT_FLAG)).collect(Collectors.toSet()).size();
    }
}

