/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.jgrapht.graph;

import java.io.Serializable;
import java.util.Map;
import shaded.org.jgrapht.Graph;
import shaded.org.jgrapht.WeightedGraph;
import shaded.org.jgrapht.graph.GraphDelegator;

public class AsWeightedGraph<V, E>
extends GraphDelegator<V, E>
implements Serializable,
WeightedGraph<V, E> {
    private static final long serialVersionUID = -716810639338971372L;
    protected final Map<E, Double> weightMap;
    private final boolean isWeightedGraph;

    public AsWeightedGraph(Graph<V, E> graph, Map<E, Double> map) {
        super(graph);
        assert (map != null);
        this.weightMap = map;
        this.isWeightedGraph = graph instanceof WeightedGraph;
    }

    @Override
    public void setEdgeWeight(E e, double d) {
        if (this.isWeightedGraph) {
            super.setEdgeWeight(e, d);
        }
        this.weightMap.put(e, d);
    }

    @Override
    public double getEdgeWeight(E e) {
        double d = this.weightMap.containsKey(e) ? this.weightMap.get(e).doubleValue() : super.getEdgeWeight(e);
        return d;
    }
}

