/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.jgrapht.alg;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import shaded.org.jgrapht.DirectedGraph;
import shaded.org.jgrapht.Graph;
import shaded.org.jgrapht.Graphs;
import shaded.org.jgrapht.alg.RankingPathElement;
import shaded.org.jgrapht.alg.RankingPathElementList;

class KShortestPathsIterator<V, E>
implements Iterator<Set<V>> {
    private V endVertex;
    private Graph<V, E> graph;
    private int k;
    private Set<V> prevImprovedVertices;
    private Map<V, RankingPathElementList<V, E>> prevSeenDataContainer;
    private Map<V, RankingPathElementList<V, E>> seenDataContainer;
    private V startVertex;
    private boolean startVertexEncountered;
    private int passNumber = 1;

    public KShortestPathsIterator(Graph<V, E> graph, V v, V v2, int n) {
        this.assertKShortestPathsIterator(graph, v);
        this.graph = graph;
        this.startVertex = v;
        this.endVertex = v2;
        this.k = n;
        this.seenDataContainer = new HashMap<V, RankingPathElementList<V, E>>();
        this.prevSeenDataContainer = new HashMap<V, RankingPathElementList<V, E>>();
        this.prevImprovedVertices = new HashSet<V>();
    }

    @Override
    public boolean hasNext() {
        if (!this.startVertexEncountered) {
            this.encounterStartVertex();
        }
        return !this.prevImprovedVertices.isEmpty();
    }

    @Override
    public Set<V> next() {
        if (!this.startVertexEncountered) {
            this.encounterStartVertex();
        }
        if (this.hasNext()) {
            HashSet hashSet = new HashSet();
            for (V v : this.prevImprovedVertices) {
                if (v.equals(this.endVertex)) continue;
                this.updateOutgoingVertices(v, hashSet);
            }
            this.savePassData(hashSet);
            ++this.passNumber;
            return hashSet;
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    RankingPathElementList<V, E> getPathElements(V v) {
        return this.seenDataContainer.get(v);
    }

    private void assertKShortestPathsIterator(Graph<V, E> graph, V v) {
        if (graph == null) {
            throw new NullPointerException("graph is null");
        }
        if (v == null) {
            throw new NullPointerException("startVertex is null");
        }
    }

    private RankingPathElementList<V, E> createSeenData(V v, E e) {
        V v2 = Graphs.getOppositeVertex(this.graph, e, v);
        RankingPathElementList<V, E> rankingPathElementList = this.prevSeenDataContainer.get(v2);
        RankingPathElementList<V, E> rankingPathElementList2 = new RankingPathElementList<V, E>(this.graph, this.k, rankingPathElementList, e, this.endVertex);
        return rankingPathElementList2;
    }

    private Iterator<E> edgesOfIterator(V v) {
        if (this.graph instanceof DirectedGraph) {
            return ((DirectedGraph)this.graph).outgoingEdgesOf(v).iterator();
        }
        return this.graph.edgesOf(v).iterator();
    }

    private void encounterStartVertex() {
        RankingPathElementList rankingPathElementList = new RankingPathElementList(this.graph, this.k, new RankingPathElement(this.startVertex));
        this.seenDataContainer.put(this.startVertex, rankingPathElementList);
        this.prevSeenDataContainer.put(this.startVertex, rankingPathElementList);
        this.prevImprovedVertices.add(this.startVertex);
        this.startVertexEncountered = true;
    }

    private void savePassData(Set<V> set) {
        for (V v : set) {
            RankingPathElementList<V, E> rankingPathElementList = this.seenDataContainer.get(v);
            RankingPathElementList<V, E> rankingPathElementList2 = new RankingPathElementList<V, E>(this.graph, rankingPathElementList.maxSize, v);
            for (RankingPathElement rankingPathElement : rankingPathElementList) {
                if (rankingPathElement.getHopCount() != this.passNumber) continue;
                rankingPathElementList2.pathElements.add(rankingPathElement);
            }
            this.prevSeenDataContainer.put((RankingPathElementList<V, E>)v, (RankingPathElementList<RankingPathElementList<V, E>, E>)rankingPathElementList2);
        }
        this.prevImprovedVertices = set;
    }

    private boolean tryToAddFirstPaths(V v, E e) {
        RankingPathElementList<V, E> rankingPathElementList = this.createSeenData(v, e);
        if (!rankingPathElementList.isEmpty()) {
            this.seenDataContainer.put((RankingPathElementList<V, E>)v, (RankingPathElementList<RankingPathElementList<V, E>, E>)rankingPathElementList);
            return true;
        }
        return false;
    }

    private boolean tryToAddNewPaths(V v, E e) {
        RankingPathElementList<V, E> rankingPathElementList = this.seenDataContainer.get(v);
        V v2 = Graphs.getOppositeVertex(this.graph, e, v);
        RankingPathElementList<V, E> rankingPathElementList2 = this.prevSeenDataContainer.get(v2);
        return rankingPathElementList.addPathElements(rankingPathElementList2, e);
    }

    private void updateOutgoingVertices(V v, Set<V> set) {
        Iterator<E> iterator = this.edgesOfIterator(v);
        while (iterator.hasNext()) {
            boolean bl;
            E e = iterator.next();
            V v2 = Graphs.getOppositeVertex(this.graph, e, v);
            if (v2 == this.startVertex) continue;
            if (this.seenDataContainer.containsKey(v2)) {
                bl = this.tryToAddNewPaths(v2, e);
                if (!bl) continue;
                set.add(v2);
                continue;
            }
            bl = this.tryToAddFirstPaths(v2, e);
            if (!bl) continue;
            set.add(v2);
        }
    }
}

