/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.jgrapht.alg;

import shaded.org.jgrapht.Graph;
import shaded.org.jgrapht.alg.AbstractPathElement;

final class BellmanFordPathElement<V, E>
extends AbstractPathElement<V, E> {
    private double cost = 0.0;
    private double epsilon;

    protected BellmanFordPathElement(Graph<V, E> graph, BellmanFordPathElement<V, E> bellmanFordPathElement, E e, double d, double d2) {
        super(graph, bellmanFordPathElement, e);
        this.cost = d;
        this.epsilon = d2;
    }

    BellmanFordPathElement(BellmanFordPathElement<V, E> bellmanFordPathElement) {
        super(bellmanFordPathElement);
        this.cost = bellmanFordPathElement.cost;
        this.epsilon = bellmanFordPathElement.epsilon;
    }

    protected BellmanFordPathElement(V v, double d) {
        super(v);
        this.cost = 0.0;
        this.epsilon = d;
    }

    public double getCost() {
        return this.cost;
    }

    protected boolean improve(BellmanFordPathElement<V, E> bellmanFordPathElement, E e, double d) {
        if (d < this.getCost() - this.epsilon) {
            this.prevPathElement = bellmanFordPathElement;
            this.prevEdge = e;
            this.cost = d;
            this.nHops = bellmanFordPathElement.getHopCount() + 1;
            return true;
        }
        return false;
    }
}

