/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.glassfish.jersey.message.internal;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.ws.rs.core.AbstractMultivaluedMap;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.RuntimeDelegate;
import shaded.org.glassfish.jersey.internal.LocalizationMessages;
import shaded.org.glassfish.jersey.internal.util.collection.ImmutableMultivaluedMap;
import shaded.org.glassfish.jersey.internal.util.collection.StringKeyIgnoreCaseMultivaluedMap;
import shaded.org.glassfish.jersey.internal.util.collection.Views;

public final class HeaderUtils {
    private static final Logger LOGGER = Logger.getLogger(HeaderUtils.class.getName());

    public static AbstractMultivaluedMap<String, String> createInbound() {
        return new StringKeyIgnoreCaseMultivaluedMap<String>();
    }

    public static <V> MultivaluedMap<String, V> empty() {
        return ImmutableMultivaluedMap.empty();
    }

    public static AbstractMultivaluedMap<String, Object> createOutbound() {
        return new StringKeyIgnoreCaseMultivaluedMap<Object>();
    }

    public static String asString(Object headerValue, RuntimeDelegate rd) {
        RuntimeDelegate.HeaderDelegate<?> hp;
        if (headerValue == null) {
            return null;
        }
        if (headerValue instanceof String) {
            return (String)headerValue;
        }
        if (rd == null) {
            rd = RuntimeDelegate.getInstance();
        }
        return (hp = rd.createHeaderDelegate(headerValue.getClass())) != null ? hp.toString(headerValue) : headerValue.toString();
    }

    public static List<String> asStringList(List<Object> headerValues, RuntimeDelegate rd) {
        if (headerValues == null || headerValues.isEmpty()) {
            return Collections.emptyList();
        }
        RuntimeDelegate delegate = rd == null ? RuntimeDelegate.getInstance() : rd;
        return Views.listView(headerValues, input -> input == null ? "[null]" : HeaderUtils.asString(input, delegate));
    }

    public static MultivaluedMap<String, String> asStringHeaders(MultivaluedMap<String, Object> headers) {
        if (headers == null) {
            return null;
        }
        RuntimeDelegate rd = RuntimeDelegate.getInstance();
        return new AbstractMultivaluedMap<String, String>(Views.mapView(headers, input -> HeaderUtils.asStringList(input, rd))){};
    }

    public static Map<String, String> asStringHeadersSingleValue(MultivaluedMap<String, Object> headers) {
        if (headers == null) {
            return null;
        }
        RuntimeDelegate rd = RuntimeDelegate.getInstance();
        return Collections.unmodifiableMap(headers.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> HeaderUtils.asHeaderString((List)entry.getValue(), rd))));
    }

    public static String asHeaderString(List<Object> values, RuntimeDelegate rd) {
        if (values == null) {
            return null;
        }
        Iterator<String> stringValues = HeaderUtils.asStringList(values, rd).iterator();
        if (!stringValues.hasNext()) {
            return "";
        }
        StringBuilder buffer = new StringBuilder(stringValues.next());
        while (stringValues.hasNext()) {
            buffer.append(',').append(stringValues.next());
        }
        return buffer.toString();
    }

    public static void checkHeaderChanges(Map<String, String> headersSnapshot, MultivaluedMap<String, Object> currentHeaders, String connectorName) {
        if (LOGGER.isLoggable(Level.WARNING)) {
            RuntimeDelegate rd = RuntimeDelegate.getInstance();
            HashSet changedHeaderNames = new HashSet();
            for (Map.Entry entry : currentHeaders.entrySet()) {
                String newValue;
                if (!headersSnapshot.containsKey(entry.getKey())) {
                    changedHeaderNames.add(entry.getKey());
                    continue;
                }
                String prevValue = headersSnapshot.get(entry.getKey());
                if (prevValue.equals(newValue = HeaderUtils.asHeaderString((List)currentHeaders.get(entry.getKey()), rd))) continue;
                changedHeaderNames.add(entry.getKey());
            }
            if (!changedHeaderNames.isEmpty() && LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.warning(LocalizationMessages.SOME_HEADERS_NOT_SENT(connectorName, ((Object)changedHeaderNames).toString()));
            }
        }
    }

    private HeaderUtils() {
        throw new AssertionError((Object)"No instances allowed.");
    }
}

