/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.eclipse.jetty.server;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.zip.Deflater;

public class DeflaterPool {
    private final Queue<Deflater> _pool;
    private final int _compressionLevel;
    private final boolean _nowrap;
    private final AtomicInteger _numDeflaters = new AtomicInteger(0);
    private final int _capacity;

    public DeflaterPool(int capacity, int compressionLevel, boolean nowrap) {
        this._capacity = capacity;
        this._compressionLevel = compressionLevel;
        this._nowrap = nowrap;
        this._pool = this._capacity != 0 ? new ConcurrentLinkedQueue<Deflater>() : null;
    }

    protected Deflater newDeflater() {
        return new Deflater(this._compressionLevel, this._nowrap);
    }

    public Deflater acquire() {
        Deflater deflater;
        if (this._capacity == 0) {
            deflater = this.newDeflater();
        } else if (this._capacity < 0) {
            deflater = this._pool.poll();
            if (deflater == null) {
                deflater = this.newDeflater();
            }
        } else {
            deflater = this._pool.poll();
            if (deflater == null) {
                deflater = this.newDeflater();
            } else {
                this._numDeflaters.decrementAndGet();
            }
        }
        return deflater;
    }

    public void release(Deflater deflater) {
        block5: {
            if (deflater == null) {
                return;
            }
            if (this._capacity == 0) {
                deflater.end();
                return;
            }
            if (this._capacity < 0) {
                deflater.reset();
                this._pool.add(deflater);
            } else {
                int d;
                do {
                    if ((d = this._numDeflaters.get()) < this._capacity) continue;
                    deflater.end();
                    break block5;
                } while (!this._numDeflaters.compareAndSet(d, d + 1));
                deflater.reset();
                this._pool.add(deflater);
            }
        }
    }
}

