/*
 * Decompiled with CFR 0.152.
 */
package shaded.net.sf.jsqlparser.statement.replace;

import java.util.List;
import shaded.net.sf.jsqlparser.expression.Expression;
import shaded.net.sf.jsqlparser.expression.operators.relational.ItemsList;
import shaded.net.sf.jsqlparser.schema.Column;
import shaded.net.sf.jsqlparser.schema.Table;
import shaded.net.sf.jsqlparser.statement.Statement;
import shaded.net.sf.jsqlparser.statement.StatementVisitor;
import shaded.net.sf.jsqlparser.statement.select.PlainSelect;

public class Replace
implements Statement {
    private Table table;
    private List<Column> columns;
    private ItemsList itemsList;
    private List<Expression> expressions;
    private boolean useValues = true;
    private boolean useIntoTables = false;

    @Override
    public void accept(StatementVisitor statementVisitor) {
        statementVisitor.visit(this);
    }

    public Table getTable() {
        return this.table;
    }

    public void setTable(Table name) {
        this.table = name;
    }

    public boolean isUseIntoTables() {
        return this.useIntoTables;
    }

    public void setUseIntoTables(boolean useIntoTables) {
        this.useIntoTables = useIntoTables;
    }

    public List<Column> getColumns() {
        return this.columns;
    }

    public ItemsList getItemsList() {
        return this.itemsList;
    }

    public void setColumns(List<Column> list) {
        this.columns = list;
    }

    public void setItemsList(ItemsList list) {
        this.itemsList = list;
    }

    public List<Expression> getExpressions() {
        return this.expressions;
    }

    public void setExpressions(List<Expression> list) {
        this.expressions = list;
    }

    public boolean isUseValues() {
        return this.useValues;
    }

    public void setUseValues(boolean useValues) {
        this.useValues = useValues;
    }

    public String toString() {
        StringBuilder sql = new StringBuilder();
        sql.append("REPLACE ");
        if (this.isUseIntoTables()) {
            sql.append("INTO ");
        }
        sql.append(this.table);
        if (this.expressions != null && this.columns != null) {
            sql.append(" SET ");
            int s = this.columns.size();
            for (int i = 0; i < s; ++i) {
                sql.append(this.columns.get(i)).append("=").append(this.expressions.get(i));
                sql.append(i < s - 1 ? ", " : "");
            }
        } else if (this.columns != null) {
            sql.append(" ").append(PlainSelect.getStringList(this.columns, true, true));
        }
        if (this.itemsList != null) {
            if (this.useValues) {
                sql.append(" VALUES");
            }
            sql.append(" ").append(this.itemsList);
        }
        return sql.toString();
    }
}

