/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.instrumentation.coverage.methodreplacement.classes;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Objects;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.DateTimeParsingUtils;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.MethodReplacementClass;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.Replacement;
import org.evomaster.client.java.instrumentation.heuristic.Truthness;
import org.evomaster.client.java.instrumentation.shared.ReplacementType;
import org.evomaster.client.java.instrumentation.shared.StringSpecialization;
import org.evomaster.client.java.instrumentation.shared.StringSpecializationInfo;
import org.evomaster.client.java.instrumentation.staticstate.ExecutionTracer;

public class DateFormatClassReplacement
implements MethodReplacementClass {
    public static final String YYYY_MM_DD = "yyyy-MM-dd";
    public static final String YYYY_MM_DD_HH_MM = "yyyy-MM-dd HH:mm";

    @Override
    public Class<?> getTargetClass() {
        return DateFormat.class;
    }

    private static Date parseSimpleDateFormat(SimpleDateFormat caller, String input, String idTemplate) throws ParseException {
        String pattern = caller.toPattern();
        if (ExecutionTracer.isTaintInput(input)) {
            StringSpecializationInfo specializationInfo;
            switch (pattern) {
                case "yyyy-MM-dd": {
                    specializationInfo = new StringSpecializationInfo(StringSpecialization.DATE_YYYY_MM_DD, pattern);
                    break;
                }
                case "yyyy-MM-dd HH:mm": {
                    specializationInfo = new StringSpecializationInfo(StringSpecialization.DATE_YYYY_MM_DD_HH_MM, pattern);
                    break;
                }
                default: {
                    specializationInfo = new StringSpecializationInfo(StringSpecialization.DATE_FORMAT_PATTERN, pattern);
                }
            }
            ExecutionTracer.addStringSpecialization(input, specializationInfo);
        }
        if (idTemplate == null) {
            return caller.parse(input);
        }
        try {
            Date res = caller.parse(input);
            ExecutionTracer.executedReplacedMethod(idTemplate, ReplacementType.EXCEPTION, new Truthness(1.0, 0.0));
            return res;
        }
        catch (ParseException e) {
            double h;
            switch (pattern) {
                case "yyyy-MM-dd": {
                    h = DateTimeParsingUtils.getHeuristicToISOLocalDateParsing(input);
                    break;
                }
                case "yyyy-MM-dd HH:mm": {
                    h = DateTimeParsingUtils.getHeuristicToDateTimeParsing(input);
                    break;
                }
                default: {
                    h = DateTimeParsingUtils.getHeuristicToDateTimePatternParsing(input, pattern);
                }
            }
            ExecutionTracer.executedReplacedMethod(idTemplate, ReplacementType.EXCEPTION, new Truthness(h, 1.0));
            throw e;
        }
    }

    @Replacement(type=ReplacementType.EXCEPTION)
    public static Date parse(DateFormat caller, String input, String idTemplate) throws ParseException {
        Objects.requireNonNull(caller);
        if (caller instanceof SimpleDateFormat) {
            SimpleDateFormat sdf = (SimpleDateFormat)caller;
            return DateFormatClassReplacement.parseSimpleDateFormat(sdf, input, idTemplate);
        }
        if (ExecutionTracer.isTaintInput(input)) {
            ExecutionTracer.addStringSpecialization(input, new StringSpecializationInfo(StringSpecialization.DATE_FORMAT_UNKNOWN_PATTERN, null));
        }
        if (idTemplate == null) {
            return caller.parse(input);
        }
        try {
            Date res = caller.parse(input);
            ExecutionTracer.executedReplacedMethod(idTemplate, ReplacementType.EXCEPTION, new Truthness(1.0, 0.0));
            return res;
        }
        catch (ParseException e) {
            ExecutionTracer.executedReplacedMethod(idTemplate, ReplacementType.EXCEPTION, new Truthness(0.0, 1.0));
            throw e;
        }
    }
}

