/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.instrumentation.coverage.methodreplacement.classes;

import java.util.Collection;
import java.util.Objects;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.CollectionsDistanceUtils;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.MethodReplacementClass;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.Replacement;
import org.evomaster.client.java.instrumentation.heuristic.Truthness;
import org.evomaster.client.java.instrumentation.heuristic.TruthnessUtils;
import org.evomaster.client.java.instrumentation.shared.ReplacementType;
import org.evomaster.client.java.instrumentation.shared.StringSpecialization;
import org.evomaster.client.java.instrumentation.shared.StringSpecializationInfo;
import org.evomaster.client.java.instrumentation.staticstate.ExecutionTracer;

public class CollectionClassReplacement
implements MethodReplacementClass {
    @Override
    public Class<?> getTargetClass() {
        return Collection.class;
    }

    @Replacement(type=ReplacementType.BOOLEAN)
    public static boolean contains(Collection c, Object o, String idTemplate) {
        Truthness t;
        Objects.requireNonNull(c);
        String inputString = null;
        if (o instanceof String) {
            inputString = (String)o;
        }
        if (ExecutionTracer.isTaintInput(inputString)) {
            for (Object value : c) {
                if (!(value instanceof String)) continue;
                ExecutionTracer.addStringSpecialization(inputString, new StringSpecializationInfo(StringSpecialization.CONSTANT, (String)value));
            }
        }
        boolean result = c.contains(o);
        if (idTemplate == null) {
            return result;
        }
        if (result) {
            t = new Truthness(1.0, 0.0);
        } else {
            double h = CollectionsDistanceUtils.getHeuristicToContains(c, o);
            t = new Truthness(h, 1.0);
        }
        ExecutionTracer.executedReplacedMethod(idTemplate, ReplacementType.BOOLEAN, t);
        return result;
    }

    @Replacement(type=ReplacementType.BOOLEAN)
    public static boolean isEmpty(Collection caller, String idTemplate) {
        Objects.requireNonNull(caller);
        boolean result = caller.isEmpty();
        if (idTemplate == null) {
            return result;
        }
        int len = caller.size();
        Truthness t = TruthnessUtils.getTruthnessToEmpty(len);
        ExecutionTracer.executedReplacedMethod(idTemplate, ReplacementType.BOOLEAN, t);
        return result;
    }
}

