/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.instrumentation.coverage;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.evomaster.client.java.instrumentation.shared.ClassName;
import org.evomaster.client.java.instrumentation.shared.ObjectiveNaming;
import org.evomaster.client.java.instrumentation.staticstate.ExecutionTracer;
import org.evomaster.client.java.instrumentation.staticstate.ObjectiveRecorder;
import org.evomaster.client.java.instrumentation.staticstate.UnitsInfoRecorder;
import shaded.org.objectweb.asm.Label;
import shaded.org.objectweb.asm.MethodVisitor;

public class LineCovMethodVisitor
extends MethodVisitor {
    private static final Set<Integer> returnCodes = Collections.unmodifiableSet(new HashSet<Integer>(Arrays.asList(172, 173, 174, 175, 176, 177)));
    private final String className;
    private final String methodName;
    private final String descriptor;
    private boolean seenAtLeastOneLine;

    public LineCovMethodVisitor(MethodVisitor mv, String className, String methodName, String descriptor) {
        super(458752, mv);
        this.className = className;
        this.methodName = methodName;
        this.descriptor = descriptor;
        this.seenAtLeastOneLine = false;
    }

    @Override
    public void visitLineNumber(int line, Label start) {
        super.visitLineNumber(line, start);
        if (this.methodName.equals("<clinit>")) {
            return;
        }
        this.seenAtLeastOneLine = true;
        UnitsInfoRecorder.markNewLine();
        ObjectiveRecorder.registerTarget(ObjectiveNaming.lineObjectiveName(this.className, line));
        this.visitLdcInsn(this.className);
        this.visitLdcInsn(this.methodName);
        this.visitLdcInsn(this.descriptor);
        this.visitLdcInsn(line);
        this.mv.visitMethodInsn(184, ClassName.get(ExecutionTracer.class).getBytecodeName(), "executedLine", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;I)V", ExecutionTracer.class.isInterface());
    }

    @Override
    public void visitInsn(int opcode) {
        if (this.seenAtLeastOneLine && returnCodes.contains(opcode)) {
            this.mv.visitMethodInsn(184, ClassName.get(ExecutionTracer.class).getBytecodeName(), "completedLastExecutedStatement", "()V", ExecutionTracer.class.isInterface());
        }
        super.visitInsn(opcode);
    }

    @Override
    public void visitMaxs(int maxStack, int maxLocals) {
        int maxElementsAddedOnStackFrame = 4;
        super.visitMaxs(Math.max(maxElementsAddedOnStackFrame, maxStack), maxLocals);
    }
}

