/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.instrumentation;

import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Deque;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import org.evomaster.client.java.instrumentation.shared.StringSpecializationInfo;
import org.evomaster.client.java.instrumentation.staticstate.ExecutionTracer;

public class AdditionalInfo
implements Serializable {
    private Set<String> queryParameters = new CopyOnWriteArraySet<String>();
    private Set<String> headers = new CopyOnWriteArraySet<String>();
    private Map<String, Set<StringSpecializationInfo>> stringSpecializations = new ConcurrentHashMap<String, Set<StringSpecializationInfo>>();
    private Deque<StatementDescription> lastExecutedStatementStack = new ArrayDeque<StatementDescription>();
    private StatementDescription noExceptionStatement = null;

    public void addSpecialization(String taintInputName, StringSpecializationInfo info) {
        if (!ExecutionTracer.getTaintType(taintInputName).isTainted()) {
            throw new IllegalArgumentException("No valid input name: " + taintInputName);
        }
        Objects.requireNonNull(info);
        this.stringSpecializations.putIfAbsent(taintInputName, new CopyOnWriteArraySet());
        Set<StringSpecializationInfo> set = this.stringSpecializations.get(taintInputName);
        set.add(info);
    }

    public Map<String, Set<StringSpecializationInfo>> getStringSpecializationsView() {
        return Collections.unmodifiableMap(this.stringSpecializations);
    }

    public void addQueryParameter(String param) {
        if (param != null && !param.isEmpty()) {
            this.queryParameters.add(param);
        }
    }

    public Set<String> getQueryParametersView() {
        return Collections.unmodifiableSet(this.queryParameters);
    }

    public void addHeader(String header) {
        if (header != null && !header.isEmpty()) {
            this.headers.add(header);
        }
    }

    public Set<String> getHeadersView() {
        return Collections.unmodifiableSet(this.headers);
    }

    public String getLastExecutedStatement() {
        if (this.lastExecutedStatementStack.isEmpty()) {
            if (this.noExceptionStatement == null) {
                return null;
            }
            return this.noExceptionStatement.line;
        }
        StatementDescription current = this.lastExecutedStatementStack.peek();
        return current.line;
    }

    public void pushLastExecutedStatement(String lastLine, String lastMethod) {
        this.noExceptionStatement = null;
        StatementDescription statement = new StatementDescription(lastLine, lastMethod);
        StatementDescription current = this.lastExecutedStatementStack.peek();
        if (current != null && lastMethod.equals(current.method)) {
            this.lastExecutedStatementStack.pop();
        }
        this.lastExecutedStatementStack.push(statement);
    }

    public void popLastExecutedStatement() {
        StatementDescription statementDescription = this.lastExecutedStatementStack.pop();
        if (this.lastExecutedStatementStack.isEmpty()) {
            this.noExceptionStatement = statementDescription;
        }
    }

    private static class StatementDescription
    implements Serializable {
        public final String line;
        public final String method;

        public StatementDescription(String line, String method) {
            this.line = line;
            this.method = method;
        }
    }
}

