/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.controller.db;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;

public class DbCleaner {
    public static void clearDatabase_H2(Connection connection) {
        DbCleaner.clearDatabase_H2(connection, null);
    }

    public static void clearDatabase_H2(Connection connection, List<String> tablesToSkip) {
        DbCleaner.clearDatabase_H2(connection, "PUBLIC", tablesToSkip);
    }

    public static void clearDatabase_H2(Connection connection, String schemaName, List<String> tablesToSkip) {
        try {
            Statement s = connection.createStatement();
            s.execute("SET REFERENTIAL_INTEGRITY FALSE");
            DbCleaner.truncateTables(tablesToSkip, s, schemaName, false);
            DbCleaner.resetSequences(s, schemaName);
            s.execute("SET REFERENTIAL_INTEGRITY TRUE");
            s.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void clearDatabase_Postgres(Connection connection) {
        DbCleaner.clearDatabase_Postgres(connection, "public", null);
    }

    public static void clearDatabase_Postgres(Connection connection, String schemaName, List<String> tablesToSkip) {
        try {
            Statement s = connection.createStatement();
            DbCleaner.truncateTables(tablesToSkip, s, schemaName, true);
            DbCleaner.resetSequences(s, schemaName);
            s.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static void truncateTables(List<String> tablesToSkip, Statement s, String schema, boolean singleCommand) throws SQLException {
        HashSet<String> tables = new HashSet<String>();
        ResultSet rs = s.executeQuery("SELECT TABLE_NAME FROM INFORMATION_SCHEMA.TABLES  where TABLE_SCHEMA='" + schema + "' AND (TABLE_TYPE='TABLE' OR TABLE_TYPE='BASE TABLE')");
        while (rs.next()) {
            tables.add(rs.getString(1));
        }
        rs.close();
        if (tables.isEmpty()) {
            throw new IllegalStateException("Could not find any table");
        }
        if (tablesToSkip != null) {
            for (String skip : tablesToSkip) {
                if (tables.stream().anyMatch(t -> t.equalsIgnoreCase(skip))) continue;
                String msg = "Asked to skip table '" + skip + "', but it does not exist.";
                msg = msg + " Existing tables in schema '" + schema + "': [" + tables.stream().collect(Collectors.joining(", ")) + "]";
                throw new IllegalStateException(msg);
            }
        }
        List tablesToClear = tables.stream().filter(n -> tablesToSkip == null || tablesToSkip.isEmpty() || !tablesToSkip.stream().anyMatch(skip -> skip.equalsIgnoreCase((String)n))).collect(Collectors.toList());
        if (singleCommand) {
            String ts = tablesToClear.stream().sorted().collect(Collectors.joining(","));
            s.executeUpdate("TRUNCATE TABLE " + ts);
        } else {
            for (String t2 : tablesToClear) {
                s.executeUpdate("TRUNCATE TABLE " + t2);
            }
        }
    }

    private static void resetSequences(Statement s, String schema) throws SQLException {
        HashSet<String> sequences = new HashSet<String>();
        ResultSet rs = s.executeQuery("SELECT SEQUENCE_NAME FROM INFORMATION_SCHEMA.SEQUENCES WHERE SEQUENCE_SCHEMA='" + schema + "'");
        while (rs.next()) {
            sequences.add(rs.getString(1));
        }
        rs.close();
        for (String seq : sequences) {
            s.executeUpdate("ALTER SEQUENCE " + seq + " RESTART WITH 1");
        }
    }
}

