/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvmanager.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import org.epics.pvmanager.ChannelWriteCallback;
import org.epics.pvmanager.MultiplexedChannelHandler;
import org.epics.pvmanager.file.FileDataSource;
import org.epics.pvmanager.file.FileFormat;
import org.epics.vtype.VType;
import org.epics.vtype.ValueFactory;

class FileChannelHandler
extends MultiplexedChannelHandler<File, Object> {
    private final File file;
    private final FileDataSource dataSource;
    private final Runnable updateTask = new Runnable(){

        @Override
        public void run() {
            FileChannelHandler.this.update();
        }
    };
    private final FileFormat format;

    FileChannelHandler(FileDataSource dataSource, String channelName, File file, FileFormat format) {
        super(channelName);
        this.file = file;
        this.dataSource = dataSource;
        this.format = format;
    }

    public void connect() {
        this.processConnection(this.file);
        this.update();
        this.dataSource.getFileWatchService().addWatcher(this.file, this.updateTask);
    }

    private void update() {
        try {
            Object value = this.readValueFromFile(this.file);
            this.processMessage(value);
        }
        catch (Exception ex) {
            this.reportExceptionToAllReadersAndWriters(ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Object readValueFromFile(File file) {
        try (FileInputStream in = new FileInputStream(file);){
            Object object = this.format.readValue(in);
            return object;
        }
        catch (Exception e) {
            this.reportExceptionToAllReadersAndWriters(e);
            return null;
        }
    }

    public void disconnect() {
        this.dataSource.getFileWatchService().removeWatcher(this.file, this.updateTask);
        this.processConnection(null);
    }

    protected boolean isConnected(File payload) {
        return payload != null && payload.exists() && payload.isFile();
    }

    protected boolean isWriteConnected(File payload) {
        return this.isConnected(payload) && this.format.isWriteSupported();
    }

    protected void write(Object newValue, ChannelWriteCallback callback) {
        VType converted;
        if (this.file == null) {
            callback.channelWritten((Exception)new RuntimeException("Channel is closed"));
        }
        if (this.format == null || !this.format.isWriteSupported()) {
            callback.channelWritten((Exception)new RuntimeException("Format does not support write"));
        }
        if (!(newValue instanceof VType) && (converted = ValueFactory.toVType((Object)newValue)) != null) {
            newValue = converted;
        }
        try (FileOutputStream out = new FileOutputStream(this.file);){
            this.format.writeValue(newValue, out);
            callback.channelWritten(null);
        }
        catch (Exception ex) {
            callback.channelWritten(ex);
        }
    }
}

