/*
 * Decompiled with CFR 0.152.
 */
package org.epics.util.text;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringUtil {
    public static final String STRING_ESCAPE_SEQUENCE_REGEX = "\\\\(\"|\\\\|'|r|n|b|t|u[0-9a-fA-F][0-9a-fA-F][0-9a-fA-F][0-9a-fA-F]|[0-3]?[0-7]?[0-7])";
    public static final String QUOTED_STRING_REGEX = "\"([^\"\\\\]|\\\\(\"|\\\\|'|r|n|b|t|u[0-9a-fA-F][0-9a-fA-F][0-9a-fA-F][0-9a-fA-F]|[0-3]?[0-7]?[0-7]))*\"";
    public static final String SINGLEQUOTED_STRING_REGEX = "'([^\"\\\\]|\\\\(\"|\\\\|'|r|n|b|t|u[0-9a-fA-F][0-9a-fA-F][0-9a-fA-F][0-9a-fA-F]|[0-3]?[0-7]?[0-7]))*'";
    public static final String DOUBLE_REGEX = "([-+]?[0-9]*\\.?[0-9]+([eE][-+]?[0-9]+)?)";
    public static final String DOUBLE_REGEX_WITH_NAN = "([-+]?[0-9]*\\.?[0-9]+([eE][-+]?[0-9]+)?)|NaN";
    static Pattern escapeSequence = Pattern.compile("\\\\(\"|\\\\|'|r|n|b|t|u[0-9a-fA-F][0-9a-fA-F][0-9a-fA-F][0-9a-fA-F]|[0-3]?[0-7]?[0-7])");

    private StringUtil() {
    }

    public static String unquote(String quotedString) {
        return StringUtil.unescapeString(quotedString.substring(1, quotedString.length() - 1));
    }

    public static String unescapeString(String escapedString) {
        Matcher match = escapeSequence.matcher(escapedString);
        StringBuffer output = new StringBuffer();
        while (match.find()) {
            match.appendReplacement(output, StringUtil.substitution(match.group()));
        }
        match.appendTail(output);
        return output.toString();
    }

    private static String substitution(String escapedToken) {
        switch (escapedToken) {
            case "\\\"": {
                return "\"";
            }
            case "\\\\": {
                return "\\\\";
            }
            case "\\'": {
                return "'";
            }
            case "\\r": {
                return "\r";
            }
            case "\\n": {
                return "\n";
            }
            case "\\b": {
                return "\b";
            }
            case "\\t": {
                return "\t";
            }
        }
        if (escapedToken.startsWith("\\u")) {
            return Character.toString((char)Long.parseLong(escapedToken.substring(2), 16));
        }
        return Character.toString((char)Long.parseLong(escapedToken.substring(1), 8));
    }

    public static List<Object> parseCSVLine(String line, String separatorRegex) {
        ArrayList<Object> matches = new ArrayList<Object>();
        int currentPosition = 0;
        Matcher separatorMatcher = Pattern.compile("^" + separatorRegex).matcher(line);
        Matcher stringMatcher = Pattern.compile("^\"([^\"\\\\]|\\\\(\"|\\\\|'|r|n|b|t|u[0-9a-fA-F][0-9a-fA-F][0-9a-fA-F][0-9a-fA-F]|[0-3]?[0-7]?[0-7]))*\"").matcher(line);
        Matcher doubleMatcher = Pattern.compile("^([-+]?[0-9]*\\.?[0-9]+([eE][-+]?[0-9]+)?)").matcher(line);
        while (currentPosition < line.length()) {
            Object token;
            if (stringMatcher.region(currentPosition, line.length()).useAnchoringBounds(true).find()) {
                token = line.substring(currentPosition + 1, stringMatcher.end() - 1);
                matches.add(StringUtil.unescapeString((String)token));
                currentPosition = stringMatcher.end();
            } else if (doubleMatcher.region(currentPosition, line.length()).useAnchoringBounds(true).find()) {
                token = Double.parseDouble(line.substring(currentPosition, doubleMatcher.end()));
                matches.add(token);
                currentPosition = doubleMatcher.end();
            } else {
                throw new IllegalArgumentException("Can't parse line: expected token at " + currentPosition + " (" + line + ")");
            }
            if (currentPosition >= line.length()) continue;
            if (!separatorMatcher.region(currentPosition, line.length()).useAnchoringBounds(true).find()) {
                throw new IllegalArgumentException("Can't parse line: expected separator at " + currentPosition + " (" + line + ")");
            }
            currentPosition = separatorMatcher.end();
        }
        return matches;
    }
}

