/*
 * Decompiled with CFR 0.152.
 */
package org.epics.util.text;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class NumberFormats {
    private static final Locale currentLocale;
    private static final DecimalFormatSymbols symbols;
    private static final Map<Integer, DecimalFormat> precisionFormats;
    private static final NumberFormat toStringFormat;
    private static final Map<String, NumberFormat> printfFormats;

    private NumberFormats() {
    }

    private static DecimalFormat createPrecisionFormat(int precision) {
        if (precision < 0) {
            throw new IllegalArgumentException("Precision must be non-negative");
        }
        if (precision == 0) {
            return new DecimalFormat("0", symbols);
        }
        StringBuilder sb = new StringBuilder("0.");
        for (int i = 0; i < precision; ++i) {
            sb.append("0");
        }
        return new DecimalFormat(sb.toString(), symbols);
    }

    public static NumberFormat precisionFormat(int precision) {
        NumberFormat format = precisionFormats.get(precision);
        if (format == null) {
            precisionFormats.put(precision, NumberFormats.createPrecisionFormat(precision));
        }
        return precisionFormats.get(precision);
    }

    public static NumberFormat toStringFormat() {
        return toStringFormat;
    }

    public static NumberFormat printfFormat(String format) {
        if (format == null || format.trim().isEmpty() || format.equals("%s")) {
            return NumberFormats.toStringFormat();
        }
        NumberFormat printfFormat = printfFormats.get(format);
        if (printfFormat != null) {
            return printfFormat;
        }
        printfFormat = new PrintfFormat(format);
        printfFormats.put(format, printfFormat);
        return printfFormat;
    }

    static {
        Locale newLocale = Locale.getDefault();
        DecimalFormatSymbols newSymbols = new DecimalFormatSymbols(newLocale);
        newSymbols.setNaN("NaN");
        newSymbols.setInfinity("Infinity");
        currentLocale = newLocale;
        symbols = newSymbols;
        precisionFormats = new ConcurrentHashMap<Integer, DecimalFormat>();
        toStringFormat = new NumberFormat(){

            @Override
            public StringBuffer format(double number, StringBuffer toAppendTo, FieldPosition pos) {
                toAppendTo.append(number);
                return toAppendTo;
            }

            @Override
            public StringBuffer format(long number, StringBuffer toAppendTo, FieldPosition pos) {
                toAppendTo.append(number);
                return toAppendTo;
            }

            @Override
            public Number parse(String source, ParsePosition parsePosition) {
                throw new UnsupportedOperationException("Not supported yet.");
            }
        };
        printfFormats = new ConcurrentHashMap<String, NumberFormat>();
    }

    static class PrintfFormat
    extends NumberFormat {
        private final String format;

        public PrintfFormat(String printfFormat) {
            boolean allOK = true;
            try {
                String.format(currentLocale, printfFormat, 0.0);
            }
            catch (Throwable th) {
                allOK = false;
            }
            this.format = allOK ? printfFormat : null;
        }

        private String internalFormat(double number) {
            if (this.format != null) {
                return String.format(currentLocale, this.format, number);
            }
            return String.valueOf(number);
        }

        @Override
        public StringBuffer format(double number, StringBuffer toAppendTo, FieldPosition pos) {
            toAppendTo.append(this.internalFormat(number));
            return toAppendTo;
        }

        @Override
        public StringBuffer format(long number, StringBuffer toAppendTo, FieldPosition pos) {
            toAppendTo.append(this.internalFormat(number));
            return toAppendTo;
        }

        @Override
        public Number parse(String source, ParsePosition parsePosition) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }
}

