/*
 * Decompiled with CFR 0.152.
 */
package org.epics.util.text;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.epics.util.array.ArrayDouble;
import org.epics.util.array.ListDouble;
import org.epics.util.text.StringUtil;

public class FunctionParser {
    public static List<Object> parseFunctionWithScalarOrArrayArguments(String string, String errorMessage) {
        return FunctionParser.parseFunctionWithScalarOrArrayArguments("(\\w+)", string, errorMessage);
    }

    public static List<Object> parseFunctionWithScalarOrArrayArguments(String nameRegex, String string, String errorMessage) {
        List<Object> parsedTokens = FunctionParser.parseFunctionAnyParameter(nameRegex, string);
        if (parsedTokens == null) {
            throw new IllegalArgumentException(errorMessage);
        }
        if (parsedTokens.size() <= 2) {
            return parsedTokens;
        }
        Object data = FunctionParser.asScalarOrList(parsedTokens.subList(1, parsedTokens.size()));
        if (data == null) {
            throw new IllegalArgumentException(errorMessage);
        }
        return Arrays.asList(parsedTokens.get(0), data);
    }

    public static Object asScalarOrList(List<Object> objects) {
        if (objects.isEmpty()) {
            return null;
        }
        if (objects.size() == 1) {
            return objects.get(0);
        }
        if (objects.get(0) instanceof Double) {
            return FunctionParser.asListDouble(objects);
        }
        if (objects.get(0) instanceof String) {
            return FunctionParser.asListString(objects);
        }
        return null;
    }

    public static ListDouble asListDouble(List<Object> objects) {
        double[] data = new double[objects.size()];
        for (int i = 0; i < objects.size(); ++i) {
            Object value = objects.get(i);
            if (!(value instanceof Double)) {
                return null;
            }
            data[i] = (Double)value;
        }
        return ArrayDouble.of(data);
    }

    public static List<String> asListString(List<Object> objects) {
        ArrayList<String> data = new ArrayList<String>();
        for (int i = 0; i < objects.size(); ++i) {
            Object value = objects.get(i);
            if (!(value instanceof String)) {
                return null;
            }
            data.add((String)value);
        }
        return data;
    }

    public static List<Object> parseFunctionAnyParameter(String string) {
        return FunctionParser.parseFunctionAnyParameter("(\\w+)", string);
    }

    public static List<Object> parseFunctionAnyParameter(String nameRegex, String string) {
        if (string.indexOf(40) == -1) {
            if (string.matches(nameRegex)) {
                return Arrays.asList(string);
            }
            return null;
        }
        String name = string.substring(0, string.indexOf(40));
        String arguments = string.substring(string.indexOf(40) + 1, string.lastIndexOf(41));
        if (!name.matches(nameRegex)) {
            return null;
        }
        ArrayList<Object> result = new ArrayList<Object>();
        result.add(name);
        try {
            List<Object> parsedArguments = StringUtil.parseCSVLine(arguments.trim(), "\\s*,\\s*");
            if (parsedArguments == null) {
                return null;
            }
            result.addAll(parsedArguments);
            return result;
        }
        catch (IllegalArgumentException ex) {
            return null;
        }
    }
}

