/*
 * Decompiled with CFR 0.152.
 */
package org.epics.util.number;

import java.math.BigInteger;

public class UnsignedConversions {
    private static final BigInteger LONG_BASE = BigInteger.valueOf(Long.MAX_VALUE).add(BigInteger.ONE).multiply(BigInteger.valueOf(2L));

    private UnsignedConversions() {
    }

    public static short toShort(byte unsignedValue) {
        return (short)(unsignedValue & 0xFF);
    }

    public static int toInt(byte unsignedValue) {
        return unsignedValue & 0xFF;
    }

    public static int toInt(short unsignedValue) {
        return unsignedValue & 0xFFFF;
    }

    public static long toLong(byte unsignedValue) {
        return (long)unsignedValue & 0xFFL;
    }

    public static long toLong(short unsignedValue) {
        return unsignedValue & 0xFFFF;
    }

    public static long toLong(int unsignedValue) {
        return (long)unsignedValue & 0xFFFFFFFFL;
    }

    public static float toFloat(byte unsignedValue) {
        return unsignedValue & 0xFF;
    }

    public static float toFloat(short unsignedValue) {
        return unsignedValue & 0xFFFF;
    }

    public static float toFloat(int unsignedValue) {
        return (long)unsignedValue & 0xFFFFFFFFL;
    }

    public static float toFloat(long unsignedValue) {
        float result = unsignedValue & Long.MAX_VALUE;
        if (unsignedValue < 0L) {
            result += 9.223372E18f;
        }
        return result;
    }

    public static double toDouble(byte unsignedValue) {
        return unsignedValue & 0xFF;
    }

    public static double toDouble(short unsignedValue) {
        return unsignedValue & 0xFFFF;
    }

    public static double toDouble(int unsignedValue) {
        return (long)unsignedValue & 0xFFFFFFFFL;
    }

    public static double toDouble(long unsignedValue) {
        double result = unsignedValue & Long.MAX_VALUE;
        if (unsignedValue < 0L) {
            result += 9.223372036854776E18;
        }
        return result;
    }

    public static BigInteger toBigInteger(long unsignedValue) {
        BigInteger result = BigInteger.valueOf(unsignedValue);
        if (unsignedValue < 0L) {
            result = result.add(LONG_BASE);
        }
        return result;
    }
}

