/*
 * Decompiled with CFR 0.152.
 */
package org.epics.util.array;

import org.epics.util.array.ArrayByte;
import org.epics.util.array.ArrayDouble;
import org.epics.util.array.ArrayFloat;
import org.epics.util.array.ArrayInteger;
import org.epics.util.array.ArrayLong;
import org.epics.util.array.ArrayShort;
import org.epics.util.array.CollectionNumber;

public class UnsafeUnwrapper {
    public static Array<?> wrappedArray(CollectionNumber coll) {
        Array<float[]> data = UnsafeUnwrapper.wrappedFloatArray(coll);
        if (data != null) {
            return data;
        }
        data = UnsafeUnwrapper.wrappedDoubleArray(coll);
        if (data != null) {
            return data;
        }
        data = UnsafeUnwrapper.wrappedByteArray(coll);
        if (data != null) {
            return data;
        }
        data = UnsafeUnwrapper.wrappedShortArray(coll);
        if (data != null) {
            return data;
        }
        data = UnsafeUnwrapper.wrappedIntArray(coll);
        if (data != null) {
            return data;
        }
        data = UnsafeUnwrapper.wrappedLongArray(coll);
        if (data != null) {
            return data;
        }
        return null;
    }

    public static Array<float[]> wrappedFloatArray(CollectionNumber coll) {
        if (coll instanceof ArrayFloat) {
            ArrayFloat wrapper = (ArrayFloat)coll;
            return new Array<float[]>(wrapper.wrappedArray(), wrapper.startIndex(), wrapper.size());
        }
        return null;
    }

    public static Array<double[]> wrappedDoubleArray(CollectionNumber coll) {
        if (coll instanceof ArrayDouble) {
            ArrayDouble wrapper = (ArrayDouble)coll;
            return new Array<double[]>(wrapper.wrappedArray(), wrapper.startIndex(), wrapper.size());
        }
        return null;
    }

    public static Array<byte[]> wrappedByteArray(CollectionNumber coll) {
        if (coll instanceof ArrayByte) {
            ArrayByte wrapper = (ArrayByte)coll;
            return new Array<byte[]>(wrapper.wrappedArray(), wrapper.startIndex(), wrapper.size());
        }
        return null;
    }

    public static Array<short[]> wrappedShortArray(CollectionNumber coll) {
        if (coll instanceof ArrayShort) {
            ArrayShort wrapper = (ArrayShort)coll;
            return new Array<short[]>(wrapper.wrappedArray(), wrapper.startIndex(), wrapper.size());
        }
        return null;
    }

    public static Array<int[]> wrappedIntArray(CollectionNumber coll) {
        if (coll instanceof ArrayInteger) {
            ArrayInteger wrapper = (ArrayInteger)coll;
            return new Array<int[]>(wrapper.wrappedArray(), wrapper.startIndex(), wrapper.size());
        }
        return null;
    }

    public static Array<long[]> wrappedLongArray(CollectionNumber coll) {
        if (coll instanceof ArrayLong) {
            ArrayLong wrapper = (ArrayLong)coll;
            return new Array<long[]>(wrapper.wrappedArray(), wrapper.startIndex(), wrapper.size());
        }
        return null;
    }

    public static Array<double[]> readSafeDoubleArray(CollectionNumber coll) {
        Array<double[]> array = UnsafeUnwrapper.wrappedDoubleArray(coll);
        if (array != null) {
            return array;
        }
        return new Array<double[]>(coll.toArray(new double[coll.size()]), 0, coll.size());
    }

    public static Array<float[]> readSafeFloatArray(CollectionNumber coll) {
        Array<float[]> array = UnsafeUnwrapper.wrappedFloatArray(coll);
        if (array != null) {
            return array;
        }
        return new Array<float[]>(coll.toArray(new float[coll.size()]), 0, coll.size());
    }

    public static Array<long[]> readSafeLongArray(CollectionNumber coll) {
        Array<long[]> array = UnsafeUnwrapper.wrappedLongArray(coll);
        if (array != null) {
            return array;
        }
        return new Array<long[]>(coll.toArray(new long[coll.size()]), 0, coll.size());
    }

    public static Array<int[]> readSafeIntArray(CollectionNumber coll) {
        Array<int[]> array = UnsafeUnwrapper.wrappedIntArray(coll);
        if (array != null) {
            return array;
        }
        return new Array<int[]>(coll.toArray(new int[coll.size()]), 0, coll.size());
    }

    public static Array<short[]> readSafeShortArray(CollectionNumber coll) {
        Array<short[]> array = UnsafeUnwrapper.wrappedShortArray(coll);
        if (array != null) {
            return array;
        }
        return new Array<short[]>(coll.toArray(new short[coll.size()]), 0, coll.size());
    }

    public static Array<byte[]> readSafeByteArray(CollectionNumber coll) {
        Array<byte[]> array = UnsafeUnwrapper.wrappedByteArray(coll);
        if (array != null) {
            return array;
        }
        return new Array<byte[]>(coll.toArray(new byte[coll.size()]), 0, coll.size());
    }

    public static Array<double[]> writeSafeDoubleArray(CollectionNumber coll) {
        Array<double[]> array = UnsafeUnwrapper.wrappedDoubleArray(coll);
        if (array != null && !((ArrayDouble)coll).isReadOnly()) {
            return array;
        }
        return new Array<double[]>(coll.toArray(new double[coll.size()]), 0, coll.size());
    }

    public static Array<float[]> writeSafeFloatArray(CollectionNumber coll) {
        Array<float[]> array = UnsafeUnwrapper.wrappedFloatArray(coll);
        if (array != null && !((ArrayFloat)coll).isReadOnly()) {
            return array;
        }
        return new Array<float[]>(coll.toArray(new float[coll.size()]), 0, coll.size());
    }

    public static Array<long[]> writeSafeLongArray(CollectionNumber coll) {
        Array<long[]> array = UnsafeUnwrapper.wrappedLongArray(coll);
        if (array != null && !((ArrayLong)coll).isReadOnly()) {
            return array;
        }
        return new Array<long[]>(coll.toArray(new long[coll.size()]), 0, coll.size());
    }

    public static Array<int[]> writeSafeIntArray(CollectionNumber coll) {
        Array<int[]> array = UnsafeUnwrapper.wrappedIntArray(coll);
        if (array != null && !((ArrayInteger)coll).isReadOnly()) {
            return array;
        }
        return new Array<int[]>(coll.toArray(new int[coll.size()]), 0, coll.size());
    }

    public static Array<short[]> writeSafeShortArray(CollectionNumber coll) {
        Array<short[]> array = UnsafeUnwrapper.wrappedShortArray(coll);
        if (array != null && !((ArrayShort)coll).isReadOnly()) {
            return array;
        }
        return new Array<short[]>(coll.toArray(new short[coll.size()]), 0, coll.size());
    }

    public static Array<byte[]> writeSafeByteArray(CollectionNumber coll) {
        Array<byte[]> array = UnsafeUnwrapper.wrappedByteArray(coll);
        if (array != null && !((ArrayByte)coll).isReadOnly()) {
            return array;
        }
        return new Array<byte[]>(coll.toArray(new byte[coll.size()]), 0, coll.size());
    }

    public static final class Array<T> {
        public final T array;
        public final int startIndex;
        public final int size;

        Array(T array, int startIndex, int size) {
            this.array = array;
            this.startIndex = startIndex;
            this.size = size;
        }
    }
}

