/*
 * Decompiled with CFR 0.152.
 */
package org.epics.util.array;

import org.epics.util.array.CollectionULong;
import org.epics.util.array.IteratorULong;
import org.epics.util.array.ListNumber;
import org.epics.util.number.UnsignedConversions;

public abstract class ListULong
implements ListNumber,
CollectionULong {
    @Override
    public IteratorULong iterator() {
        return new IteratorULong(){
            private int index;

            @Override
            public boolean hasNext() {
                return this.index < ListULong.this.size();
            }

            @Override
            public long nextLong() {
                return ListULong.this.getLong(this.index++);
            }
        };
    }

    @Override
    public double getDouble(int index) {
        return UnsignedConversions.toDouble(this.getLong(index));
    }

    @Override
    public float getFloat(int index) {
        return UnsignedConversions.toFloat(this.getLong(index));
    }

    @Override
    public int getInt(int index) {
        return (int)this.getLong(index);
    }

    @Override
    public short getShort(int index) {
        return (short)this.getLong(index);
    }

    @Override
    public byte getByte(int index) {
        return (byte)this.getLong(index);
    }

    @Override
    public void setDouble(int index, double value) {
        this.setLong(index, (long)value);
    }

    @Override
    public void setFloat(int index, float value) {
        this.setLong(index, (long)value);
    }

    @Override
    public void setLong(int index, long value) {
        throw new UnsupportedOperationException("Read only list.");
    }

    @Override
    public void setInt(int index, int value) {
        this.setLong(index, value);
    }

    @Override
    public void setShort(int index, short value) {
        this.setLong(index, value);
    }

    @Override
    public void setByte(int index, byte value) {
        this.setLong(index, value);
    }

    @Override
    public void setAll(int index, ListNumber list) {
        if (index + list.size() > this.size()) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Elements: " + list.size() + ", Size: " + this.size());
        }
        for (int i = 0; i < list.size(); ++i) {
            this.setLong(index + i, list.getLong(i));
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ListULong) {
            ListULong other = (ListULong)obj;
            if (this.size() != other.size()) {
                return false;
            }
            for (int i = 0; i < this.size(); ++i) {
                if (this.getLong(i) == other.getLong(i)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int result = 1;
        for (int i = 0; i < this.size(); ++i) {
            long element = this.getLong(i);
            int elementHash = (int)(element ^ element >>> 32);
            result = 31 * result + elementHash;
        }
        return result;
    }

    public String toString() {
        int i;
        if (this.size() == 0) {
            return "[]";
        }
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        for (i = 0; i < this.size() - 1; ++i) {
            builder.append(Long.toUnsignedString(this.getLong(i))).append(", ");
        }
        builder.append(Long.toUnsignedString(this.getLong(i))).append("]");
        return builder.toString();
    }

    @Override
    public ListULong subList(final int fromIndex, int toIndex) {
        if (fromIndex < 0 || toIndex > this.size() || fromIndex > toIndex) {
            throw new IndexOutOfBoundsException("fromIndex: " + fromIndex + " toIndex: " + toIndex + ", size: " + this.size());
        }
        final int size = toIndex - fromIndex;
        return new ListULong(){

            @Override
            public long getLong(int index) {
                if (index < 0 || index >= size) {
                    throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + size);
                }
                return ListULong.this.getLong(fromIndex + index);
            }

            @Override
            public void setLong(int index, long value) {
                if (index < 0 || index >= size) {
                    throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + size);
                }
                ListULong.this.setLong(fromIndex + index, value);
            }

            @Override
            public int size() {
                return size;
            }
        };
    }
}

