/*
 * Decompiled with CFR 0.152.
 */
package org.epics.util.array;

import org.epics.util.array.CollectionShort;
import org.epics.util.array.IteratorShort;
import org.epics.util.array.ListNumber;

public abstract class ListShort
implements ListNumber,
CollectionShort {
    @Override
    public IteratorShort iterator() {
        return new IteratorShort(){
            private int index;

            @Override
            public boolean hasNext() {
                return this.index < ListShort.this.size();
            }

            @Override
            public short nextShort() {
                return ListShort.this.getShort(this.index++);
            }
        };
    }

    @Override
    public double getDouble(int index) {
        return this.getShort(index);
    }

    @Override
    public float getFloat(int index) {
        return this.getShort(index);
    }

    @Override
    public long getLong(int index) {
        return this.getShort(index);
    }

    @Override
    public int getInt(int index) {
        return this.getShort(index);
    }

    @Override
    public byte getByte(int index) {
        return (byte)this.getShort(index);
    }

    @Override
    public void setDouble(int index, double value) {
        this.setShort(index, (short)value);
    }

    @Override
    public void setFloat(int index, float value) {
        this.setShort(index, (short)value);
    }

    @Override
    public void setLong(int index, long value) {
        this.setShort(index, (short)value);
    }

    @Override
    public void setInt(int index, int value) {
        this.setShort(index, (short)value);
    }

    @Override
    public void setShort(int index, short value) {
        throw new UnsupportedOperationException("Read only list.");
    }

    @Override
    public void setByte(int index, byte value) {
        this.setShort(index, value);
    }

    @Override
    public void setAll(int index, ListNumber list) {
        if (index + list.size() > this.size()) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Elements: " + list.size() + ", Size: " + this.size());
        }
        for (int i = 0; i < list.size(); ++i) {
            this.setShort(index + i, list.getShort(i));
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ListShort) {
            ListShort other = (ListShort)obj;
            if (this.size() != other.size()) {
                return false;
            }
            for (int i = 0; i < this.size(); ++i) {
                if (this.getShort(i) == other.getShort(i)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int result = 1;
        for (int i = 0; i < this.size(); ++i) {
            result = 31 * result + this.getShort(i);
        }
        return result;
    }

    public String toString() {
        int i;
        if (this.size() == 0) {
            return "[]";
        }
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        for (i = 0; i < this.size() - 1; ++i) {
            builder.append(this.getShort(i)).append(", ");
        }
        builder.append(this.getShort(i)).append("]");
        return builder.toString();
    }

    @Override
    public ListShort subList(final int fromIndex, int toIndex) {
        if (fromIndex < 0 || toIndex > this.size() || fromIndex > toIndex) {
            throw new IndexOutOfBoundsException("fromIndex: " + fromIndex + " toIndex: " + toIndex + ", size: " + this.size());
        }
        final int size = toIndex - fromIndex;
        return new ListShort(){

            @Override
            public short getShort(int index) {
                if (index < 0 || index >= size) {
                    throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + size);
                }
                return ListShort.this.getShort(fromIndex + index);
            }

            @Override
            public void setShort(int index, short value) {
                if (index < 0 || index >= size) {
                    throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + size);
                }
                ListShort.this.setShort(fromIndex + index, value);
            }

            @Override
            public int size() {
                return size;
            }
        };
    }
}

