/*
 * Decompiled with CFR 0.152.
 */
package org.epics.util.array;

import org.epics.util.array.CollectionFloat;
import org.epics.util.array.IteratorFloat;
import org.epics.util.array.ListNumber;

public abstract class ListFloat
implements ListNumber,
CollectionFloat {
    @Override
    public IteratorFloat iterator() {
        return new IteratorFloat(){
            private int index;

            @Override
            public boolean hasNext() {
                return this.index < ListFloat.this.size();
            }

            @Override
            public float nextFloat() {
                return ListFloat.this.getFloat(this.index++);
            }
        };
    }

    @Override
    public double getDouble(int index) {
        return this.getFloat(index);
    }

    @Override
    public long getLong(int index) {
        return (long)this.getFloat(index);
    }

    @Override
    public int getInt(int index) {
        return (int)this.getFloat(index);
    }

    @Override
    public short getShort(int index) {
        return (short)this.getFloat(index);
    }

    @Override
    public byte getByte(int index) {
        return (byte)this.getFloat(index);
    }

    @Override
    public void setDouble(int index, double value) {
        this.setFloat(index, (float)value);
    }

    @Override
    public void setFloat(int index, float value) {
        throw new UnsupportedOperationException("Read only list.");
    }

    @Override
    public void setLong(int index, long value) {
        this.setFloat(index, value);
    }

    @Override
    public void setInt(int index, int value) {
        this.setFloat(index, value);
    }

    @Override
    public void setShort(int index, short value) {
        this.setFloat(index, value);
    }

    @Override
    public void setByte(int index, byte value) {
        this.setFloat(index, value);
    }

    @Override
    public void setAll(int index, ListNumber list) {
        if (index + list.size() > this.size()) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Elements: " + list.size() + ", Size: " + this.size());
        }
        for (int i = 0; i < list.size(); ++i) {
            this.setFloat(index + i, list.getFloat(i));
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ListFloat) {
            ListFloat other = (ListFloat)obj;
            if (this.size() != other.size()) {
                return false;
            }
            for (int i = 0; i < this.size(); ++i) {
                if (Float.floatToIntBits(this.getFloat(i)) == Float.floatToIntBits(other.getFloat(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int result = 1;
        for (int i = 0; i < this.size(); ++i) {
            result = 31 * result + Float.floatToIntBits(this.getFloat(i));
        }
        return result;
    }

    public String toString() {
        int i;
        if (this.size() == 0) {
            return "[]";
        }
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        for (i = 0; i < this.size() - 1; ++i) {
            builder.append(this.getFloat(i)).append(", ");
        }
        builder.append(this.getFloat(i)).append("]");
        return builder.toString();
    }

    @Override
    public ListFloat subList(final int fromIndex, int toIndex) {
        if (fromIndex < 0 || toIndex > this.size() || fromIndex > toIndex) {
            throw new IndexOutOfBoundsException("fromIndex: " + fromIndex + " toIndex: " + toIndex + ", size: " + this.size());
        }
        final int size = toIndex - fromIndex;
        return new ListFloat(){

            @Override
            public float getFloat(int index) {
                if (index < 0 || index >= size) {
                    throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + size);
                }
                return ListFloat.this.getFloat(fromIndex + index);
            }

            @Override
            public void setFloat(int index, float value) {
                if (index < 0 || index >= size) {
                    throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + size);
                }
                ListFloat.this.setFloat(fromIndex + index, value);
            }

            @Override
            public int size() {
                return size;
            }
        };
    }
}

