/*
 * Decompiled with CFR 0.152.
 */
package org.epics.util.array;

import org.epics.util.array.CollectionDouble;
import org.epics.util.array.IteratorDouble;
import org.epics.util.array.ListNumber;

public abstract class ListDouble
implements ListNumber,
CollectionDouble {
    @Override
    public IteratorDouble iterator() {
        return new IteratorDouble(){
            private int index;

            @Override
            public boolean hasNext() {
                return this.index < ListDouble.this.size();
            }

            @Override
            public double nextDouble() {
                return ListDouble.this.getDouble(this.index++);
            }
        };
    }

    @Override
    public float getFloat(int index) {
        return (float)this.getDouble(index);
    }

    @Override
    public long getLong(int index) {
        return (long)this.getDouble(index);
    }

    @Override
    public int getInt(int index) {
        return (int)this.getDouble(index);
    }

    @Override
    public short getShort(int index) {
        return (short)this.getDouble(index);
    }

    @Override
    public byte getByte(int index) {
        return (byte)this.getDouble(index);
    }

    @Override
    public void setDouble(int index, double value) {
        throw new UnsupportedOperationException("Read only list.");
    }

    @Override
    public void setFloat(int index, float value) {
        this.setDouble(index, value);
    }

    @Override
    public void setLong(int index, long value) {
        this.setDouble(index, value);
    }

    @Override
    public void setInt(int index, int value) {
        this.setDouble(index, value);
    }

    @Override
    public void setShort(int index, short value) {
        this.setDouble(index, value);
    }

    @Override
    public void setByte(int index, byte value) {
        this.setDouble(index, value);
    }

    @Override
    public void setAll(int index, ListNumber list) {
        if (index + list.size() > this.size()) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Elements: " + list.size() + ", Size: " + this.size());
        }
        for (int i = 0; i < list.size(); ++i) {
            this.setDouble(index + i, list.getDouble(i));
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ListDouble) {
            ListDouble other = (ListDouble)obj;
            if (this.size() != other.size()) {
                return false;
            }
            for (int i = 0; i < this.size(); ++i) {
                if (Double.doubleToLongBits(this.getDouble(i)) == Double.doubleToLongBits(other.getDouble(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int result = 1;
        for (int i = 0; i < this.size(); ++i) {
            long bits = Double.doubleToLongBits(this.getDouble(i));
            result = 31 * result + (int)(bits ^ bits >>> 32);
        }
        return result;
    }

    public String toString() {
        int i;
        if (this.size() == 0) {
            return "[]";
        }
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        for (i = 0; i < this.size() - 1; ++i) {
            builder.append(this.getDouble(i)).append(", ");
        }
        builder.append(this.getDouble(i)).append("]");
        return builder.toString();
    }

    @Override
    public ListDouble subList(final int fromIndex, int toIndex) {
        if (fromIndex < 0 || toIndex > this.size() || fromIndex > toIndex) {
            throw new IndexOutOfBoundsException("fromIndex: " + fromIndex + " toIndex: " + toIndex + ", size: " + this.size());
        }
        final int size = toIndex - fromIndex;
        return new ListDouble(){

            @Override
            public double getDouble(int index) {
                if (index < 0 || index >= size) {
                    throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + size);
                }
                return ListDouble.this.getDouble(fromIndex + index);
            }

            @Override
            public void setDouble(int index, double value) {
                if (index < 0 || index >= size) {
                    throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + size);
                }
                ListDouble.this.setDouble(fromIndex + index, value);
            }

            @Override
            public int size() {
                return size;
            }
        };
    }
}

