/*
 * Decompiled with CFR 0.152.
 */
package org.epics.util.array;

import org.epics.util.array.ListDouble;

public class CircularBufferDouble
extends ListDouble {
    private double[] data;
    private int startOffset;
    private int endOffset;
    private final int maxCapacity;
    private boolean reachedMax;

    public CircularBufferDouble(int maxCapacity) {
        this(Math.min(10, maxCapacity), maxCapacity);
    }

    public CircularBufferDouble(int initialCapacity, int maxCapacity) {
        this.data = new double[initialCapacity];
        this.maxCapacity = maxCapacity;
    }

    private void resize() {
        int oldSize = this.data.length;
        int newSize = oldSize * 2;
        if (newSize > this.maxCapacity) {
            newSize = this.maxCapacity + 1;
            this.reachedMax = true;
        }
        double[] newData = new double[newSize];
        System.arraycopy(this.data, 0, newData, 0, oldSize);
        this.data = newData;
    }

    @Override
    public double getDouble(int index) {
        if ((index += this.startOffset) >= this.data.length) {
            index -= this.data.length;
        }
        return this.data[index];
    }

    @Override
    public int size() {
        int size = this.endOffset - this.startOffset;
        if (size < 0) {
            size += this.data.length;
        }
        return size;
    }

    public void addDouble(double value) {
        this.data[this.endOffset] = value;
        ++this.endOffset;
        if (this.endOffset == this.data.length && !this.reachedMax) {
            this.resize();
        }
        if (this.endOffset == this.data.length) {
            this.endOffset = 0;
        }
        if (this.endOffset == this.startOffset) {
            ++this.startOffset;
        }
        if (this.startOffset == this.data.length) {
            this.startOffset = 0;
        }
    }

    public void clear() {
        this.startOffset = 0;
        this.endOffset = 0;
    }

    public int getCurrentCapacity() {
        return this.reachedMax ? this.maxCapacity : this.data.length;
    }
}

