/*
 * Decompiled with CFR 0.152.
 */
package org.epics.util.array;

import org.epics.util.array.ListInteger;

public class BufferInteger
extends ListInteger {
    private int[] data;
    private int endOffset;

    public BufferInteger() {
        this(10);
    }

    public BufferInteger(int initialCapacity) {
        this.data = new int[initialCapacity];
    }

    private void resize() {
        int oldSize = this.data.length;
        int newSize = oldSize * 2;
        int[] newData = new int[newSize];
        System.arraycopy(this.data, 0, newData, 0, oldSize);
        this.data = newData;
    }

    @Override
    public int getInt(int index) {
        if (index >= this.endOffset) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        return this.data[index];
    }

    @Override
    public int size() {
        int size = this.endOffset;
        return size;
    }

    public void addInt(int value) {
        this.data[this.endOffset] = value;
        ++this.endOffset;
        if (this.endOffset == this.data.length) {
            this.resize();
        }
    }

    public void clear() {
        this.endOffset = 0;
    }

    public int getCurrentCapacity() {
        return this.data.length;
    }
}

