/*
 * Decompiled with CFR 0.152.
 */
package org.epics.util.array;

import java.io.Serializable;
import org.epics.util.array.CollectionNumber;
import org.epics.util.array.CollectionNumbers;
import org.epics.util.array.IteratorULong;
import org.epics.util.array.ListNumber;
import org.epics.util.array.ListULong;

public final class ArrayULong
extends ListULong
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final long[] array;
    private final int startIndex;
    private final int size;
    private final boolean checkBoundaries;
    private final boolean readOnly;

    public ArrayULong(CollectionNumber coll) {
        this(coll.toArray(new long[coll.size()]), 0, coll.size(), false);
    }

    ArrayULong(long[] array, int startIndex, int size, boolean readOnly) {
        if (startIndex < 0 || startIndex + size > array.length) {
            throw new IndexOutOfBoundsException("Start index: " + startIndex + ", Size: " + size + ", Array length: " + array.length);
        }
        this.array = array;
        this.readOnly = readOnly;
        this.startIndex = startIndex;
        this.size = size;
        this.checkBoundaries = startIndex != 0 || size != array.length;
    }

    @Override
    public final IteratorULong iterator() {
        return new IteratorULong(){
            private int index;
            {
                this.index = ArrayULong.this.startIndex;
            }

            @Override
            public boolean hasNext() {
                return this.index < ArrayULong.this.startIndex + ArrayULong.this.size;
            }

            @Override
            public long nextLong() {
                return ArrayULong.this.array[this.index++];
            }
        };
    }

    @Override
    public final int size() {
        return this.size;
    }

    @Override
    public long getLong(int index) {
        if (this.checkBoundaries && (index < 0 || index >= this.size)) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
        return this.array[this.startIndex + index];
    }

    @Override
    public void setLong(int index, long value) {
        if (!this.readOnly) {
            if (this.checkBoundaries && (index < 0 || index >= this.size)) {
                throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
            }
        } else {
            throw new UnsupportedOperationException("Read only list.");
        }
        this.array[this.startIndex + index] = value;
    }

    @Override
    public ArrayULong subList(int fromIndex, int toIndex) {
        return new ArrayULong(this.array, fromIndex + this.startIndex, toIndex - fromIndex, this.readOnly);
    }

    @Override
    public void setAll(int index, ListNumber list) {
        if (list instanceof ArrayULong) {
            if (this.readOnly) {
                throw new UnsupportedOperationException("Read only list.");
            }
            ArrayULong other = (ArrayULong)list;
            System.arraycopy(other.array, other.startIndex, this.array, this.startIndex + index, other.size);
        } else {
            super.setAll(index, list);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ArrayULong) {
            ArrayULong other = (ArrayULong)obj;
            if (this.array == other.array && this.startIndex == other.startIndex && this.size == other.size) {
                return true;
            }
        }
        return super.equals(obj);
    }

    @Override
    public <T> T toArray(T array) {
        if (array instanceof long[]) {
            long[] longArray = ((long[])array).length < this.size() ? new long[this.size()] : (long[])array;
            System.arraycopy(this.array, this.startIndex, longArray, 0, this.size);
            return (T)longArray;
        }
        return super.toArray(array);
    }

    long[] wrappedArray() {
        return this.array;
    }

    int startIndex() {
        return this.startIndex;
    }

    boolean isReadOnly() {
        return this.readOnly;
    }

    public static ArrayULong of(long ... values) {
        return CollectionNumbers.unmodifiableListULong(values);
    }
}

