/*
 * Decompiled with CFR 0.152.
 */
package org.epics.util.array;

import java.io.Serializable;
import java.util.Arrays;
import org.epics.util.array.ListBoolean;

public final class ArrayBoolean
extends ListBoolean
implements Serializable {
    private static final long serialVersionUID = 7493025761455302915L;
    private final boolean[] array;
    private final boolean readOnly;

    public ArrayBoolean(boolean ... array) {
        this(array, true);
    }

    public ArrayBoolean(boolean[] array, boolean readOnly) {
        this.array = array;
        this.readOnly = readOnly;
    }

    @Override
    public final int size() {
        return this.array.length;
    }

    @Override
    public boolean getBoolean(int index) {
        return this.array[index];
    }

    @Override
    public void setBoolean(int index, boolean value) {
        if (this.readOnly) {
            throw new UnsupportedOperationException("Read only list.");
        }
        this.array[index] = value;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof ArrayBoolean) {
            return Arrays.equals(this.array, ((ArrayBoolean)obj).array);
        }
        return super.equals(obj);
    }

    boolean[] wrappedArray() {
        return this.array;
    }

    public static ArrayBoolean of(boolean ... values) {
        return new ArrayBoolean(values);
    }
}

