/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvdata.util.namedValues;

import java.io.PrintStream;
import org.epics.pvdata.util.namedValues.NamedValues;
import org.epics.pvdata.util.namedValues.NamedValuesColumnFormatter;
import org.epics.pvdata.util.namedValues.NamedValuesRowFormatter;

public abstract class NamedValuesFormatter {
    public static final int STYLE_ROWS = 1;
    public static final int STYLE_COLUMNS = 2;
    boolean shouldDisplayLabels_ = true;
    protected String[] labels = new String[0];
    protected String[][] cells = new String[0][];
    protected int numRows = 0;
    protected int numCols = 0;

    public static NamedValuesFormatter create(int style) {
        if (style == 1) {
            return new NamedValuesRowFormatter();
        }
        return new NamedValuesColumnFormatter();
    }

    public void assignNamedValues(NamedValues namedValues) {
        this.labels = namedValues.getLabels();
        this.cells = namedValues.getValues();
        this.updateDimensions();
    }

    protected int getColumnWidth(int col) {
        String longest = "";
        for (int row = 0; row < this.numRows; ++row) {
            String text = this.getCell(row, col);
            if (text.length() <= longest.length()) continue;
            longest = text;
        }
        return longest.length();
    }

    public void display(PrintStream out) {
        String[] spaces = new String[this.numCols];
        for (int n = 0; n < spaces.length; ++n) {
            int width = this.getColumnWidth(n) + 2;
            StringBuffer space = new StringBuffer(width);
            for (int i = 0; i < width; ++i) {
                space.append(' ');
            }
            spaces[n] = space.toString();
        }
        for (int m = 0; m < this.numRows; ++m) {
            for (int n = 0; n < this.numCols; ++n) {
                out.print(this.getFormattedCell(m, n, spaces[n]));
            }
            out.println("");
        }
    }

    public boolean getWhetherDisplayLabels() {
        return this.shouldDisplayLabels_;
    }

    public void setWhetherDisplayLabels(boolean yesno) {
        this.shouldDisplayLabels_ = yesno;
        this.updateDimensions();
    }

    protected static String centerText(String text, String space) {
        int rem = space.length() - text.length();
        int b = rem / 2;
        int a = rem - b;
        return space.substring(0, a) + text + space.substring(0, b);
    }

    protected static String leftJustifyText(String text, String space) {
        return text + space.substring(text.length());
    }

    protected static String rightJustifyText(String text, String space) {
        return space.substring(text.length()) + text;
    }

    public abstract boolean isLabelCell(int var1, int var2);

    public abstract String getCell(int var1, int var2);

    public abstract String getFormattedCell(int var1, int var2, String var3);

    protected abstract void updateDimensions();
}

