/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvdata.property;

import org.epics.pvdata.property.TimeStamp;

public class TimeStampFactory
implements TimeStamp {
    static final long milliSecPerSec = 1000L;
    static final long microSecPerSec = 1000000L;
    static final long nanoSecPerSec = 1000000000L;
    static final long posixEpochAtEpicsEpoch = 631152000L;
    private long secondsPastEpoch = 0L;
    private int nanoseconds = 0;
    private int userTag = 0;

    public static TimeStamp create() {
        return new TimeStampFactory();
    }

    @Override
    public int getUserTag() {
        return this.userTag;
    }

    @Override
    public void setUserTag(int userTag) {
        this.userTag = userTag;
    }

    @Override
    public void add(double seconds) {
        long secs = (long)seconds;
        long nano = (long)((seconds - (double)secs) * 1.0E9);
        this.nanoseconds = (int)((long)this.nanoseconds + nano);
        if ((long)this.nanoseconds > 1000000000L) {
            this.nanoseconds = (int)((long)this.nanoseconds - 1000000000L);
            ++this.secondsPastEpoch;
        } else if ((long)this.nanoseconds < -1000000000L) {
            this.nanoseconds = (int)((long)this.nanoseconds + -1000000000L);
            --this.secondsPastEpoch;
        }
        this.secondsPastEpoch += secs;
    }

    @Override
    public void add(long seconds) {
        this.secondsPastEpoch += seconds;
    }

    @Override
    public double diff(TimeStamp a, TimeStamp b) {
        double result = a.getSecondsPastEpoch() - b.getSecondsPastEpoch();
        return result += (double)(a.getNanoseconds() - b.getNanoseconds()) / 1.0E9;
    }

    @Override
    public boolean equals(TimeStamp other) {
        long sdiff = TimeStampFactory.diffInt(this, other);
        return sdiff == 0L;
    }

    @Override
    public boolean le(TimeStamp other) {
        long sdiff = TimeStampFactory.diffInt(this, other);
        return sdiff <= 0L;
    }

    @Override
    public boolean lt(TimeStamp other) {
        long sdiff = TimeStampFactory.diffInt(this, other);
        return sdiff < 0L;
    }

    @Override
    public long getEpicsSecondsPastEpoch() {
        return this.secondsPastEpoch - 631152000L;
    }

    @Override
    public long getMilliSeconds() {
        return this.secondsPastEpoch * 1000L + (long)(this.nanoseconds / 1000000);
    }

    @Override
    public int getNanoseconds() {
        return this.nanoseconds;
    }

    @Override
    public long getSecondsPastEpoch() {
        return this.secondsPastEpoch;
    }

    @Override
    public void normalize() {
        if (this.nanoseconds >= 0 && (long)this.nanoseconds < 1000000000L) {
            return;
        }
        while ((long)this.nanoseconds >= 1000000000L) {
            this.nanoseconds = (int)((long)this.nanoseconds - 1000000000L);
            ++this.secondsPastEpoch;
        }
        while (this.nanoseconds < 0) {
            this.nanoseconds = (int)((long)this.nanoseconds + 1000000000L);
            --this.secondsPastEpoch;
        }
    }

    @Override
    public void put(long secondsPastEpoch, int nanoseconds) {
        this.secondsPastEpoch = secondsPastEpoch;
        this.nanoseconds = nanoseconds;
        this.normalize();
    }

    @Override
    public void put(long milliSeconds) {
        this.secondsPastEpoch = milliSeconds / 1000L;
        this.nanoseconds = (int)(milliSeconds % 1000L * 1000000L);
    }

    @Override
    public void getCurrentTime() {
        long currentTime = System.currentTimeMillis();
        this.secondsPastEpoch = currentTime / 1000L;
        this.nanoseconds = (int)((currentTime - this.secondsPastEpoch * 1000L) * 1000000L);
    }

    private static long diffInt(TimeStamp left, TimeStamp right) {
        long sl = left.getSecondsPastEpoch();
        int nl = left.getNanoseconds();
        long sr = right.getSecondsPastEpoch();
        int nr = right.getNanoseconds();
        long sdiff = sl - sr;
        sdiff *= 1000000000L;
        return sdiff += (long)(nl - nr);
    }
}

