/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvdata.property;

import org.epics.pvdata.property.PVTimeStamp;
import org.epics.pvdata.property.TimeStamp;
import org.epics.pvdata.property.TimeStampFactory;
import org.epics.pvdata.pv.PVField;
import org.epics.pvdata.pv.PVInt;
import org.epics.pvdata.pv.PVLong;
import org.epics.pvdata.pv.PVStructure;
import org.epics.pvdata.pv.Type;

public class PVTimeStampFactory
implements PVTimeStamp {
    private PVLong pvSecs = null;
    private PVInt pvNano = null;
    private PVInt pvUserTag = null;
    private static final String noTimeStampFound = "No timeStamp structure was located";
    private static final String notAttached = "Not attached to an timeStamp structure";

    public static PVTimeStamp create() {
        return new PVTimeStampFactory();
    }

    @Override
    public boolean attach(PVField pvField) {
        if (pvField.getField().getType() != Type.structure) {
            throw new IllegalArgumentException(noTimeStampFound);
        }
        PVStructure pvStructure = (PVStructure)pvField;
        do {
            PVField xxx;
            if ((xxx = pvStructure.getSubField("secondsPastEpoch")) != null) {
                xxx = pvStructure.getSubField("nanoseconds");
            }
            if (xxx != null) {
                xxx = pvStructure.getSubField("userTag");
            }
            if (xxx != null) {
                this.pvSecs = pvStructure.getLongField("secondsPastEpoch");
                this.pvNano = pvStructure.getIntField("nanoseconds");
                this.pvUserTag = pvStructure.getIntField("userTag");
                if (this.pvSecs != null && this.pvNano != null && this.pvUserTag != null) {
                    return true;
                }
            }
            this.pvSecs = null;
            this.pvNano = null;
            this.pvUserTag = null;
        } while ((pvStructure = pvStructure.getParent()) != null);
        return false;
    }

    @Override
    public void detach() {
        this.pvSecs = null;
        this.pvUserTag = null;
        this.pvNano = null;
    }

    @Override
    public boolean isAttached() {
        return this.pvSecs != null && this.pvNano != null;
    }

    @Override
    public void get(TimeStamp timeStamp) {
        if (this.pvSecs == null || this.pvNano == null) {
            throw new IllegalStateException(notAttached);
        }
        timeStamp.put(this.pvSecs.get(), this.pvNano.get());
        timeStamp.setUserTag(this.pvUserTag.get());
    }

    @Override
    public boolean set(TimeStamp timeStamp) {
        if (this.pvSecs == null || this.pvNano == null || this.pvUserTag == null) {
            throw new IllegalStateException(notAttached);
        }
        if (this.pvSecs.isImmutable() || this.pvNano.isImmutable()) {
            return false;
        }
        TimeStamp current = TimeStampFactory.create();
        this.get(current);
        boolean returnValue = false;
        if (current.getSecondsPastEpoch() != timeStamp.getSecondsPastEpoch()) {
            this.pvSecs.put(timeStamp.getSecondsPastEpoch());
            returnValue = true;
        }
        if (current.getNanoseconds() != timeStamp.getNanoseconds()) {
            this.pvNano.put(timeStamp.getNanoseconds());
            returnValue = true;
        }
        if (current.getUserTag() != timeStamp.getUserTag()) {
            this.pvUserTag.put(timeStamp.getUserTag());
            returnValue = true;
        }
        return returnValue;
    }
}

