/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvdata.property;

import org.epics.pvdata.property.MultiChoice;
import org.epics.pvdata.pv.ByteArrayData;
import org.epics.pvdata.pv.PVByteArray;
import org.epics.pvdata.pv.PVField;
import org.epics.pvdata.pv.PVScalarArray;
import org.epics.pvdata.pv.PVStringArray;
import org.epics.pvdata.pv.PVStructure;
import org.epics.pvdata.pv.ScalarType;
import org.epics.pvdata.pv.StringArrayData;
import org.epics.pvdata.pv.Type;

public class MultiChoiceFactory {
    private static final int nBitsPerByte = 8;

    public static MultiChoice getMultiChoice(PVField pvField) {
        if (pvField.getField().getType() != Type.structure) {
            return null;
        }
        PVStructure pvStructure = (PVStructure)pvField;
        PVField pvf = pvStructure.getSubField("bitMask");
        if (pvf == null) {
            return null;
        }
        if (pvf.getField().getType() != Type.scalarArray) {
            return null;
        }
        PVScalarArray pva = (PVScalarArray)pvf;
        if (pva.getScalarArray().getElementType() != ScalarType.pvByte) {
            return null;
        }
        PVByteArray pvBitMask = (PVByteArray)pva;
        pvf = pvStructure.getSubField("choices");
        if (pvf == null) {
            return null;
        }
        if (pvf.getField().getType() != Type.scalarArray) {
            return null;
        }
        pva = (PVScalarArray)pvf;
        if (pva.getScalarArray().getElementType() != ScalarType.pvString) {
            return null;
        }
        PVStringArray pvChoices = (PVStringArray)pva;
        return new MultiChoiceImpl(pvBitMask, pvChoices);
    }

    private static class MultiChoiceImpl
    implements MultiChoice {
        private final ByteArrayData byteArrayData = new ByteArrayData();
        private final StringArrayData stringArrayData = new StringArrayData();
        private final PVByteArray pvBitMask;
        private final PVStringArray pvChoices;
        private ChoicesImpl choices = new ChoicesImpl();
        private String[] choiceValues = null;

        private MultiChoiceImpl(PVByteArray pvBitMask, PVStringArray pvChoices) {
            this.pvBitMask = pvBitMask;
            this.pvChoices = pvChoices;
        }

        @Override
        public int registerChoice(String choice) {
            this.ensureLength();
            int length = this.pvChoices.getLength();
            this.pvChoices.get(0, length, this.stringArrayData);
            String[] theChoices = (String[])this.stringArrayData.data;
            for (int i = 0; i < length; ++i) {
                if (!choice.equals(theChoices[i])) continue;
                return i;
            }
            String[] newStr = new String[]{choice};
            for (int i = 0; i < this.pvChoices.getCapacity(); ++i) {
                if (theChoices[i] != null) continue;
                this.pvChoices.put(i, 1, newStr, 0);
                return i;
            }
            this.pvChoices.put(length, 1, newStr, 0);
            return length;
        }

        @Override
        public byte[] getBitMask() {
            this.ensureLength();
            this.pvBitMask.get(0, this.pvBitMask.getLength(), this.byteArrayData);
            return (byte[])this.byteArrayData.data;
        }

        @Override
        public String[] getChoices() {
            this.pvChoices.get(0, this.pvChoices.getLength(), this.stringArrayData);
            return (String[])this.stringArrayData.data;
        }

        @Override
        public MultiChoice.Choices getSelectedChoices() {
            this.ensureLength();
            int length = this.pvChoices.getLength();
            this.pvChoices.get(0, length, this.stringArrayData);
            String[] theChoices = (String[])this.stringArrayData.data;
            this.pvBitMask.get(0, this.pvBitMask.getLength(), this.byteArrayData);
            byte[] data = (byte[])this.byteArrayData.data;
            int index = 0;
            for (int i = 0; i < length; ++i) {
                if (!this.isSet(data, i)) continue;
                this.choices.setChoice(theChoices[i], index);
                ++index;
            }
            this.choices.setLength(index);
            return this.choices;
        }

        @Override
        public void clear() {
            this.ensureLength();
            this.pvBitMask.get(0, this.pvBitMask.getLength(), this.byteArrayData);
            byte[] data = (byte[])this.byteArrayData.data;
            for (int i = 0; i < data.length; ++i) {
                data[i] = 0;
            }
        }

        @Override
        public void setBit(int index) {
            this.ensureLength();
            this.pvBitMask.get(0, this.pvBitMask.getLength(), this.byteArrayData);
            byte[] data = (byte[])this.byteArrayData.data;
            byte offset = (byte)(index % 8);
            byte mask = (byte)(1 << offset);
            int n = index / 8;
            data[n] = (byte)(data[n] | mask);
        }

        private void ensureLength() {
            int length = this.pvChoices.getLength();
            this.pvChoices.get(0, length, this.stringArrayData);
            String[] theChoices = (String[])this.stringArrayData.data;
            if (theChoices == this.choiceValues) {
                return;
            }
            this.choiceValues = theChoices;
            int nwords = length / 8 + 1;
            if (this.pvBitMask.getCapacity() < nwords) {
                this.pvBitMask.setCapacity(nwords);
            }
            this.choices.setChoices(theChoices);
        }

        private boolean isSet(byte[] data, int index) {
            byte word = data[index / 8];
            int offset = index % 8;
            byte mask = (byte)(1 << offset);
            return (word & mask) != 0;
        }
    }

    private static class ChoicesImpl
    implements MultiChoice.Choices {
        private String[] choices = null;
        private int length = 0;

        private ChoicesImpl() {
        }

        @Override
        public String[] getChoices() {
            return this.choices;
        }

        @Override
        public int getNumberChoices() {
            return this.length;
        }

        private void setChoices(String[] choices) {
            this.choices = choices;
        }

        private void setLength(int length) {
            this.length = length;
        }

        private void setChoice(String choice, int index) {
            this.choices[index] = choice;
        }
    }
}

