/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvdata.monitor;

import org.epics.pvdata.misc.BitSet;
import org.epics.pvdata.misc.Queue;
import org.epics.pvdata.misc.QueueCreate;
import org.epics.pvdata.misc.QueueElement;
import org.epics.pvdata.monitor.MonitorElement;
import org.epics.pvdata.monitor.MonitorQueue;
import org.epics.pvdata.pv.PVStructure;

public class MonitorQueueFactory {
    private static final QueueCreate<MonitorElement> queueCreate = new QueueCreate();

    public static MonitorQueue create(MonitorElement[] monitorElements) {
        int length = monitorElements.length;
        if (length < 2) {
            throw new IllegalStateException("queueSize must be at least 2 ");
        }
        QueueElement[] queueElements = new QueueElement[length];
        for (int i = 0; i < length; ++i) {
            MonitorElementImlp monitorElement = (MonitorElementImlp)monitorElements[i];
            QueueElement<MonitorElement> queueElement = queueCreate.createQueueElement(monitorElement);
            monitorElement.setQueueElement(queueElement);
            queueElements[i] = queueElement;
        }
        Queue<MonitorElement> queue = queueCreate.create(queueElements);
        return new MonitorQueueImpl(queue);
    }

    public static MonitorElement createMonitorElement(PVStructure pvStructure) {
        return new MonitorElementImlp(pvStructure);
    }

    private static class MonitorQueueImpl
    implements MonitorQueue {
        private final Queue<MonitorElement> queue;

        MonitorQueueImpl(Queue<MonitorElement> queue) {
            this.queue = queue;
        }

        @Override
        public void clear() {
            this.queue.clear();
        }

        @Override
        public int capacity() {
            return this.queue.capacity();
        }

        @Override
        public int getNumberFree() {
            return this.queue.getNumberFree();
        }

        @Override
        public MonitorElement getFree() {
            QueueElement<MonitorElement> queueElement = this.queue.getFree();
            if (queueElement == null) {
                return null;
            }
            return queueElement.getObject();
        }

        @Override
        public void setUsed(MonitorElement monitorElement) {
            MonitorElementImlp temp = (MonitorElementImlp)monitorElement;
            this.queue.setUsed(temp.getQueueElement());
        }

        @Override
        public MonitorElement getUsed() {
            QueueElement<MonitorElement> queueElement = this.queue.getUsed();
            if (queueElement == null) {
                return null;
            }
            return queueElement.getObject();
        }

        @Override
        public void releaseUsed(MonitorElement monitorElement) {
            MonitorElementImlp temp = (MonitorElementImlp)monitorElement;
            this.queue.releaseUsed(temp.getQueueElement());
        }

        public String toString() {
            return this.queue.toString();
        }
    }

    private static class MonitorElementImlp
    implements MonitorElement {
        private final PVStructure pvStructure;
        private final BitSet changedBitSet;
        private final BitSet overrunBitSet;
        private QueueElement<MonitorElement> queueElement = null;

        MonitorElementImlp(PVStructure pvStructure) {
            this.pvStructure = pvStructure;
            if (pvStructure != null) {
                int numberFields = pvStructure.getNumberFields();
                this.changedBitSet = new BitSet(numberFields);
                this.overrunBitSet = new BitSet(numberFields);
            } else {
                this.changedBitSet = null;
                this.overrunBitSet = null;
            }
        }

        @Override
        public BitSet getChangedBitSet() {
            return this.changedBitSet;
        }

        @Override
        public BitSet getOverrunBitSet() {
            return this.overrunBitSet;
        }

        @Override
        public PVStructure getPVStructure() {
            return this.pvStructure;
        }

        private void setQueueElement(QueueElement<MonitorElement> queueElement) {
            this.queueElement = queueElement;
        }

        private QueueElement<MonitorElement> getQueueElement() {
            return this.queueElement;
        }
    }
}

