/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvdata.misc;

import org.epics.pvdata.misc.Queue;
import org.epics.pvdata.misc.QueueElement;

public class QueueCreate<T> {
    public Queue<T> create(QueueElement<T>[] queueElements) {
        return new QueueImpl<T>(queueElements);
    }

    public QueueElement<T> createQueueElement(T object) {
        return new QueueElementImpl<T>(object);
    }

    private static class QueueElementImpl<T>
    implements QueueElement<T> {
        private T object = null;

        QueueElementImpl(T object) {
            this.object = object;
        }

        @Override
        public T getObject() {
            return this.object;
        }
    }

    private static class QueueImpl<T>
    implements Queue<T> {
        private final QueueElement<T>[] queueElements;
        private final int number;
        private int numberFree = 0;
        private int numberUsed = 0;
        private int nextGetFree = 0;
        private int nextSetUsed = 0;
        private int nextGetUsed = 0;
        private int nextReleaseUsed = 0;

        QueueImpl(QueueElement<T>[] queueElements) {
            this.queueElements = queueElements;
            this.numberFree = this.number = queueElements.length;
        }

        @Override
        public void clear() {
            this.numberFree = this.number;
            this.numberUsed = 0;
            this.nextGetFree = 0;
            this.nextSetUsed = 0;
            this.nextGetUsed = 0;
            this.nextReleaseUsed = 0;
        }

        @Override
        public int capacity() {
            return this.number;
        }

        @Override
        public int getNumberFree() {
            return this.numberFree;
        }

        @Override
        public QueueElement<T> getFree() {
            if (this.numberFree == 0) {
                return null;
            }
            --this.numberFree;
            QueueElement<T> queueElement = this.queueElements[this.nextGetFree++];
            if (this.nextGetFree >= this.number) {
                this.nextGetFree = 0;
            }
            return queueElement;
        }

        @Override
        public QueueElement<T> getUsed() {
            if (this.numberUsed == 0) {
                return null;
            }
            QueueElement<T> queueElement = this.queueElements[this.nextGetUsed++];
            if (this.nextGetUsed >= this.number) {
                this.nextGetUsed = 0;
            }
            return queueElement;
        }

        @Override
        public void releaseUsed(QueueElement<T> queueElement) {
            if (queueElement != this.queueElements[this.nextReleaseUsed++]) {
                throw new IllegalStateException("not queueElement returned by last call to getUsed");
            }
            if (this.nextReleaseUsed >= this.number) {
                this.nextReleaseUsed = 0;
            }
            --this.numberUsed;
            ++this.numberFree;
        }

        @Override
        public void setUsed(QueueElement<T> queueElement) {
            if (queueElement != this.queueElements[this.nextSetUsed++]) {
                throw new IllegalStateException("not correct queueElement");
            }
            ++this.numberUsed;
            if (this.nextSetUsed >= this.number) {
                this.nextSetUsed = 0;
            }
        }

        public String toString() {
            return "number " + this.number + " numberFree " + this.numberFree + " numberUsed " + this.numberUsed + " nextGetFree " + this.nextGetFree + " nextSetUsed " + this.nextSetUsed + " nextGetUsed " + this.nextGetUsed + " nextReleaseUsed " + this.nextReleaseUsed;
        }
    }
}

