/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvdata.misc;

import org.epics.pvdata.misc.MessageNode;
import org.epics.pvdata.misc.MessageQueue;
import org.epics.pvdata.pv.MessageType;

public class MessageQueueFactory {
    public static MessageQueue create(int size) {
        return new MessageQueueImpl(size);
    }

    private static class MessageQueueImpl
    implements MessageQueue {
        private MessageNode[] messageNodes;
        private int size;
        private int numFree;
        private int nextFree = 0;
        private int nextMessage = 0;
        private int numOverrun = 0;

        private MessageQueueImpl(int size) {
            this.messageNodes = new MessageNode[size];
            for (int i = 0; i < size; ++i) {
                this.messageNodes[i] = new MessageNode();
            }
            this.size = size;
            this.numFree = size;
        }

        @Override
        public MessageNode get() {
            if (this.numFree == this.size) {
                return null;
            }
            MessageNode value = this.messageNodes[this.nextMessage++];
            if (this.nextMessage == this.size) {
                this.nextMessage = 0;
            }
            ++this.numFree;
            return value;
        }

        @Override
        public boolean put(String message, MessageType messageType, boolean replaceLast) {
            MessageNode messageNode = null;
            boolean ok = true;
            if (this.numFree == 0) {
                int n;
                if (this.nextFree == 0) {
                    n = this.size - 1;
                } else {
                    int n2 = this.nextFree;
                    n = n2;
                    this.nextFree = n2 - 1;
                }
                int index = n;
                messageNode = this.messageNodes[index];
                ++this.numOverrun;
                ok = false;
            } else {
                messageNode = this.messageNodes[this.nextFree];
                ++this.nextFree;
                if (this.nextFree == this.size) {
                    this.nextFree = 0;
                }
                --this.numFree;
            }
            messageNode.message = message;
            messageNode.messageType = messageType;
            return ok;
        }

        @Override
        public boolean isEmpty() {
            return this.numFree == this.size;
        }

        @Override
        public boolean isFull() {
            return this.numFree == 0;
        }

        @Override
        public int getClearOverrun() {
            int value = this.numOverrun;
            this.numOverrun = 0;
            return value;
        }
    }
}

