/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvdata.factory;

import org.epics.pvdata.factory.FieldFactory;
import org.epics.pvdata.pv.Field;
import org.epics.pvdata.pv.FieldCreate;
import org.epics.pvdata.pv.Scalar;
import org.epics.pvdata.pv.ScalarArray;
import org.epics.pvdata.pv.ScalarType;
import org.epics.pvdata.pv.StandardField;
import org.epics.pvdata.pv.Structure;
import org.epics.pvdata.pv.StructureArray;
import org.epics.pvdata.pv.Type;

public final class StandardFieldFactory {
    private static StandardFieldImpl impl = null;
    private static FieldCreate fieldCreate = FieldFactory.getFieldCreate();
    private static Structure alarmField;
    private static Structure timeStampField;
    private static Structure displayField;
    private static Structure controlField;
    private static Structure booleanAlarmField;
    private static Structure byteAlarmField;
    private static Structure shortAlarmField;
    private static Structure intAlarmField;
    private static Structure longAlarmField;
    private static Structure floatAlarmField;
    private static Structure doubleAlarmField;
    private static Structure enumeratedAlarmField;

    public static synchronized StandardField getStandardField() {
        if (impl == null) {
            impl = new StandardFieldImpl();
            StandardFieldFactory.initStatic();
        }
        return impl;
    }

    private static void initStatic() {
        Field[] fields = new Field[3];
        String[] alarmFieldNames = new String[]{"severity", "status", "message"};
        fields[0] = fieldCreate.createScalar(ScalarType.pvInt);
        fields[1] = fieldCreate.createScalar(ScalarType.pvInt);
        fields[2] = fieldCreate.createScalar(ScalarType.pvString);
        alarmField = fieldCreate.createStructure("alarm_t", alarmFieldNames, fields);
        fields = new Field[3];
        String[] timeStampFieldNames = new String[]{"secondsPastEpoch", "nanoseconds", "userTag"};
        fields[0] = fieldCreate.createScalar(ScalarType.pvLong);
        fields[1] = fieldCreate.createScalar(ScalarType.pvInt);
        fields[2] = fieldCreate.createScalar(ScalarType.pvInt);
        timeStampField = fieldCreate.createStructure("time_t", timeStampFieldNames, fields);
        fields = new Field[5];
        String[] displayFieldNames = new String[]{"limitLow", "limitHigh", "description", "format", "units"};
        fields[0] = fieldCreate.createScalar(ScalarType.pvDouble);
        fields[1] = fieldCreate.createScalar(ScalarType.pvDouble);
        fields[2] = fieldCreate.createScalar(ScalarType.pvString);
        fields[3] = fieldCreate.createScalar(ScalarType.pvString);
        fields[4] = fieldCreate.createScalar(ScalarType.pvString);
        displayField = fieldCreate.createStructure("display_t", displayFieldNames, fields);
        fields = new Field[3];
        String[] controlFieldNames = new String[]{"limitLow", "limitHigh", "minStep"};
        fields[0] = fieldCreate.createScalar(ScalarType.pvDouble);
        fields[1] = fieldCreate.createScalar(ScalarType.pvDouble);
        fields[2] = fieldCreate.createScalar(ScalarType.pvDouble);
        controlField = fieldCreate.createStructure("control_t", controlFieldNames, fields);
        fields = new Field[4];
        String[] booleanAlarmFieldNames = new String[]{"active", "falseSeverity", "trueSeverity", "changeStateSeverity"};
        fields[0] = fieldCreate.createScalar(ScalarType.pvBoolean);
        fields[1] = fieldCreate.createScalar(ScalarType.pvInt);
        fields[2] = fieldCreate.createScalar(ScalarType.pvInt);
        fields[3] = fieldCreate.createScalar(ScalarType.pvInt);
        booleanAlarmField = fieldCreate.createStructure("valueAlarm_t", booleanAlarmFieldNames, fields);
        fields = new Field[10];
        String[] scalarAlarmFieldNames = new String[]{"active", "lowAlarmLimit", "lowWarningLimit", "highWarningLimit", "highAlarmLimit", "lowAlarmSeverity", "lowWarningSeverity", "highWarningSeverity", "highAlarmSeverity", "hysteresis"};
        fields[0] = fieldCreate.createScalar(ScalarType.pvBoolean);
        fields[1] = fieldCreate.createScalar(ScalarType.pvByte);
        fields[2] = fieldCreate.createScalar(ScalarType.pvByte);
        fields[3] = fieldCreate.createScalar(ScalarType.pvByte);
        fields[4] = fieldCreate.createScalar(ScalarType.pvByte);
        fields[5] = fieldCreate.createScalar(ScalarType.pvInt);
        fields[6] = fieldCreate.createScalar(ScalarType.pvInt);
        fields[7] = fieldCreate.createScalar(ScalarType.pvInt);
        fields[8] = fieldCreate.createScalar(ScalarType.pvInt);
        fields[9] = fieldCreate.createScalar(ScalarType.pvByte);
        byteAlarmField = fieldCreate.createStructure("valueAlarm_t", scalarAlarmFieldNames, fields);
        fields = new Field[]{fieldCreate.createScalar(ScalarType.pvBoolean), fieldCreate.createScalar(ScalarType.pvShort), fieldCreate.createScalar(ScalarType.pvShort), fieldCreate.createScalar(ScalarType.pvShort), fieldCreate.createScalar(ScalarType.pvShort), fieldCreate.createScalar(ScalarType.pvInt), fieldCreate.createScalar(ScalarType.pvInt), fieldCreate.createScalar(ScalarType.pvInt), fieldCreate.createScalar(ScalarType.pvInt), fieldCreate.createScalar(ScalarType.pvShort)};
        shortAlarmField = fieldCreate.createStructure("valueAlarm_t", scalarAlarmFieldNames, fields);
        fields = new Field[]{fieldCreate.createScalar(ScalarType.pvBoolean), fieldCreate.createScalar(ScalarType.pvInt), fieldCreate.createScalar(ScalarType.pvInt), fieldCreate.createScalar(ScalarType.pvInt), fieldCreate.createScalar(ScalarType.pvInt), fieldCreate.createScalar(ScalarType.pvInt), fieldCreate.createScalar(ScalarType.pvInt), fieldCreate.createScalar(ScalarType.pvInt), fieldCreate.createScalar(ScalarType.pvInt), fieldCreate.createScalar(ScalarType.pvInt)};
        intAlarmField = fieldCreate.createStructure("valueAlarm_t", scalarAlarmFieldNames, fields);
        fields = new Field[]{fieldCreate.createScalar(ScalarType.pvBoolean), fieldCreate.createScalar(ScalarType.pvLong), fieldCreate.createScalar(ScalarType.pvLong), fieldCreate.createScalar(ScalarType.pvLong), fieldCreate.createScalar(ScalarType.pvLong), fieldCreate.createScalar(ScalarType.pvInt), fieldCreate.createScalar(ScalarType.pvInt), fieldCreate.createScalar(ScalarType.pvInt), fieldCreate.createScalar(ScalarType.pvInt), fieldCreate.createScalar(ScalarType.pvLong)};
        longAlarmField = fieldCreate.createStructure("valueAlarm_t", scalarAlarmFieldNames, fields);
        fields = new Field[]{fieldCreate.createScalar(ScalarType.pvBoolean), fieldCreate.createScalar(ScalarType.pvFloat), fieldCreate.createScalar(ScalarType.pvFloat), fieldCreate.createScalar(ScalarType.pvFloat), fieldCreate.createScalar(ScalarType.pvFloat), fieldCreate.createScalar(ScalarType.pvInt), fieldCreate.createScalar(ScalarType.pvInt), fieldCreate.createScalar(ScalarType.pvInt), fieldCreate.createScalar(ScalarType.pvInt), fieldCreate.createScalar(ScalarType.pvFloat)};
        floatAlarmField = fieldCreate.createStructure("valueAlarm_t", scalarAlarmFieldNames, fields);
        fields = new Field[]{fieldCreate.createScalar(ScalarType.pvBoolean), fieldCreate.createScalar(ScalarType.pvDouble), fieldCreate.createScalar(ScalarType.pvDouble), fieldCreate.createScalar(ScalarType.pvDouble), fieldCreate.createScalar(ScalarType.pvDouble), fieldCreate.createScalar(ScalarType.pvInt), fieldCreate.createScalar(ScalarType.pvInt), fieldCreate.createScalar(ScalarType.pvInt), fieldCreate.createScalar(ScalarType.pvInt), fieldCreate.createScalar(ScalarType.pvDouble)};
        doubleAlarmField = fieldCreate.createStructure("valueAlarm_t", scalarAlarmFieldNames, fields);
        fields = new Field[3];
        String[] enumeratedAlarmFieldNames = new String[]{"active", "stateSeverity", "changeStateSeverity"};
        fields[0] = fieldCreate.createScalar(ScalarType.pvBoolean);
        fields[1] = fieldCreate.createScalarArray(ScalarType.pvInt);
        fields[2] = fieldCreate.createScalar(ScalarType.pvInt);
        enumeratedAlarmField = fieldCreate.createStructure("valueAlarm_t", enumeratedAlarmFieldNames, fields);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static Structure createProperties(String id, Field field, String properties) {
        String[] fieldNames;
        Field[] fields;
        Structure valueAlarm;
        int numProp;
        boolean gotValueAlarm;
        boolean gotControl;
        boolean gotDisplay;
        boolean gotTimeStamp;
        boolean gotAlarm;
        block18: {
            Type type;
            block19: {
                gotAlarm = false;
                gotTimeStamp = false;
                gotDisplay = false;
                gotControl = false;
                gotValueAlarm = false;
                numProp = 0;
                if (properties.contains("alarm")) {
                    gotAlarm = true;
                    ++numProp;
                }
                if (properties.contains("timeStamp")) {
                    gotTimeStamp = true;
                    ++numProp;
                }
                if (properties.contains("display")) {
                    gotDisplay = true;
                    ++numProp;
                }
                if (properties.contains("control")) {
                    gotControl = true;
                    ++numProp;
                }
                if (properties.contains("valueAlarm")) {
                    gotValueAlarm = true;
                    ++numProp;
                }
                valueAlarm = null;
                type = field.getType();
                if (!gotValueAlarm) break block18;
                if (type != Type.scalar && type != Type.scalarArray) break block19;
                ScalarType scalarType = type == Type.scalar ? ((Scalar)field).getScalarType() : ((ScalarArray)field).getElementType();
                switch (scalarType) {
                    case pvBoolean: {
                        valueAlarm = booleanAlarmField;
                        break block18;
                    }
                    case pvByte: {
                        valueAlarm = byteAlarmField;
                        break block18;
                    }
                    case pvShort: {
                        valueAlarm = shortAlarmField;
                        break block18;
                    }
                    case pvInt: {
                        valueAlarm = intAlarmField;
                        break block18;
                    }
                    case pvLong: {
                        valueAlarm = longAlarmField;
                        break block18;
                    }
                    case pvFloat: {
                        valueAlarm = floatAlarmField;
                        break block18;
                    }
                    case pvDouble: {
                        valueAlarm = doubleAlarmField;
                        break block18;
                    }
                    default: {
                        throw new IllegalArgumentException("valueAlarm property for illegal type");
                    }
                }
            }
            if (type != Type.structure) throw new IllegalArgumentException("valueAlarm property for illegal type");
            Structure structure = (Structure)field;
            fields = structure.getFields();
            fieldNames = structure.getFieldNames();
            if (fields.length != 2) throw new IllegalArgumentException("valueAlarm property for illegal type");
            Field first = fields[0];
            Field second = fields[1];
            if (!fieldNames[0].equals("index") || !fieldNames[1].equals("choices") || first.getType() != Type.scalar || second.getType() != Type.scalarArray) throw new IllegalArgumentException("valueAlarm property for illegal type");
            Scalar scalarFirst = (Scalar)first;
            ScalarArray scalarArraySecond = (ScalarArray)second;
            if (scalarFirst.getScalarType() != ScalarType.pvInt || scalarArraySecond.getElementType() != ScalarType.pvString) throw new IllegalArgumentException("valueAlarm property for illegal type");
            valueAlarm = enumeratedAlarmField;
        }
        int numFields = numProp + 1;
        fields = new Field[numFields];
        fieldNames = new String[numFields];
        int next = 0;
        fieldNames[0] = "value";
        fields[next++] = field;
        if (gotAlarm) {
            fieldNames[next] = "alarm";
            fields[next++] = alarmField;
        }
        if (gotTimeStamp) {
            fieldNames[next] = "timeStamp";
            fields[next++] = timeStampField;
        }
        if (gotDisplay) {
            fieldNames[next] = "display";
            fields[next++] = displayField;
        }
        if (gotControl) {
            fieldNames[next] = "control";
            fields[next++] = controlField;
        }
        if (!gotValueAlarm) return fieldCreate.createStructure(id, fieldNames, fields);
        fieldNames[next] = "valueAlarm";
        fields[next++] = valueAlarm;
        return fieldCreate.createStructure(id, fieldNames, fields);
    }

    private static final class StandardFieldImpl
    implements StandardField {
        StandardFieldImpl() {
        }

        @Override
        public Structure scalar(ScalarType scalarType, String properties) {
            Scalar field = fieldCreate.createScalar(scalarType);
            return StandardFieldFactory.createProperties("epics:nt/NTScalar:1.0", field, properties);
        }

        @Override
        public Structure scalarArray(ScalarType elementType, String properties) {
            ScalarArray field = fieldCreate.createScalarArray(elementType);
            return StandardFieldFactory.createProperties("epics:nt/NTScalarArray:1.0", field, properties);
        }

        @Override
        public Structure structureArray(Structure structure, String properties) {
            StructureArray field = fieldCreate.createStructureArray(structure);
            return StandardFieldFactory.createProperties("epics:nt/NTStructureArray:1.0", field, properties);
        }

        @Override
        public Structure enumerated() {
            Field[] fields = new Field[2];
            String[] fieldNames = new String[]{"index", "choices"};
            fields[0] = fieldCreate.createScalar(ScalarType.pvInt);
            fields[1] = fieldCreate.createScalarArray(ScalarType.pvString);
            return fieldCreate.createStructure("enum_t", fieldNames, fields);
        }

        @Override
        public Structure enumerated(String properties) {
            Structure field = this.enumerated();
            return StandardFieldFactory.createProperties("epics:nt/NTEnum:1.0", field, properties);
        }

        @Override
        public Structure alarm() {
            return alarmField;
        }

        @Override
        public Structure timeStamp() {
            return timeStampField;
        }

        @Override
        public Structure display() {
            return displayField;
        }

        @Override
        public Structure control() {
            return controlField;
        }

        @Override
        public Structure booleanAlarm() {
            return booleanAlarmField;
        }

        @Override
        public Structure byteAlarm() {
            return byteAlarmField;
        }

        @Override
        public Structure shortAlarm() {
            return shortAlarmField;
        }

        @Override
        public Structure intAlarm() {
            return intAlarmField;
        }

        @Override
        public Structure longAlarm() {
            return longAlarmField;
        }

        @Override
        public Structure floatAlarm() {
            return floatAlarmField;
        }

        @Override
        public Structure doubleAlarm() {
            return doubleAlarmField;
        }

        @Override
        public Structure enumeratedAlarm() {
            return enumeratedAlarmField;
        }
    }
}

