/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvdata.factory;

import java.util.Formatter;
import org.epics.pvdata.factory.BasePVBoolean;
import org.epics.pvdata.factory.BasePVBooleanArray;
import org.epics.pvdata.factory.BasePVByte;
import org.epics.pvdata.factory.BasePVByteArray;
import org.epics.pvdata.factory.BasePVDouble;
import org.epics.pvdata.factory.BasePVDoubleArray;
import org.epics.pvdata.factory.BasePVFloat;
import org.epics.pvdata.factory.BasePVFloatArray;
import org.epics.pvdata.factory.BasePVInt;
import org.epics.pvdata.factory.BasePVIntArray;
import org.epics.pvdata.factory.BasePVLong;
import org.epics.pvdata.factory.BasePVLongArray;
import org.epics.pvdata.factory.BasePVShort;
import org.epics.pvdata.factory.BasePVShortArray;
import org.epics.pvdata.factory.BasePVString;
import org.epics.pvdata.factory.BasePVStringArray;
import org.epics.pvdata.factory.BasePVStructure;
import org.epics.pvdata.factory.BasePVStructureArray;
import org.epics.pvdata.factory.BasePVUByte;
import org.epics.pvdata.factory.BasePVUByteArray;
import org.epics.pvdata.factory.BasePVUInt;
import org.epics.pvdata.factory.BasePVUIntArray;
import org.epics.pvdata.factory.BasePVULong;
import org.epics.pvdata.factory.BasePVULongArray;
import org.epics.pvdata.factory.BasePVUShort;
import org.epics.pvdata.factory.BasePVUShortArray;
import org.epics.pvdata.factory.BasePVUnion;
import org.epics.pvdata.factory.BasePVUnionArray;
import org.epics.pvdata.factory.ConvertFactory;
import org.epics.pvdata.factory.FieldFactory;
import org.epics.pvdata.pv.Convert;
import org.epics.pvdata.pv.Field;
import org.epics.pvdata.pv.FieldCreate;
import org.epics.pvdata.pv.PVArray;
import org.epics.pvdata.pv.PVDataCreate;
import org.epics.pvdata.pv.PVField;
import org.epics.pvdata.pv.PVScalar;
import org.epics.pvdata.pv.PVScalarArray;
import org.epics.pvdata.pv.PVScalarType;
import org.epics.pvdata.pv.PVStructure;
import org.epics.pvdata.pv.PVStructureArray;
import org.epics.pvdata.pv.PVUnion;
import org.epics.pvdata.pv.PVUnionArray;
import org.epics.pvdata.pv.Scalar;
import org.epics.pvdata.pv.ScalarArray;
import org.epics.pvdata.pv.ScalarType;
import org.epics.pvdata.pv.Structure;
import org.epics.pvdata.pv.StructureArray;
import org.epics.pvdata.pv.Type;
import org.epics.pvdata.pv.Union;
import org.epics.pvdata.pv.UnionArray;

public class PVDataFactory {
    private PVDataFactory() {
    }

    public static synchronized PVDataCreate getPVDataCreate() {
        return PVDataCreateImpl.getPVDataCreate();
    }

    private static final class PVDataCreateImpl
    implements PVDataCreate {
        private static FieldCreate fieldCreate = FieldFactory.getFieldCreate();
        private static Convert convert = ConvertFactory.getConvert();
        private static PVDataCreateImpl singleImplementation = null;

        private PVDataCreateImpl() {
        }

        private static synchronized PVDataCreateImpl getPVDataCreate() {
            if (singleImplementation == null) {
                singleImplementation = new PVDataCreateImpl();
            }
            return singleImplementation;
        }

        @Override
        public PVField createPVField(Field field) {
            switch (field.getType()) {
                case scalar: {
                    return this.createPVScalar((Scalar)field);
                }
                case scalarArray: {
                    return this.createPVScalarArray((ScalarArray)field);
                }
                case structure: {
                    return new BasePVStructure((Structure)field);
                }
                case structureArray: {
                    return new BasePVStructureArray((StructureArray)field);
                }
                case union: {
                    return new BasePVUnion((Union)field);
                }
                case unionArray: {
                    return new BasePVUnionArray((UnionArray)field);
                }
            }
            throw new IllegalArgumentException("Illegal Type");
        }

        @Override
        public PVField createPVField(PVField fieldToClone) {
            switch (fieldToClone.getField().getType()) {
                case scalar: {
                    return this.createPVScalar((PVScalar)fieldToClone);
                }
                case scalarArray: {
                    return this.createPVScalarArray((PVScalarArray)fieldToClone);
                }
                case structure: {
                    return this.createPVStructure((PVStructure)fieldToClone);
                }
                case structureArray: {
                    PVStructureArray from = (PVStructureArray)fieldToClone;
                    PVStructureArray to = this.createPVStructureArray(from.getStructureArray());
                    convert.copyStructureArray(from, to);
                    return to;
                }
                case union: {
                    return this.createPVUnion((PVUnion)fieldToClone);
                }
                case unionArray: {
                    PVUnionArray from = (PVUnionArray)fieldToClone;
                    PVUnionArray to = this.createPVUnionArray(from.getUnionArray());
                    convert.copyUnionArray(from, to);
                    return to;
                }
            }
            throw new IllegalArgumentException("Illegal Type");
        }

        @Override
        public PVScalar createPVScalar(Scalar scalar) {
            switch (scalar.getScalarType()) {
                case pvBoolean: {
                    return new BasePVBoolean(scalar);
                }
                case pvByte: {
                    return new BasePVByte(scalar);
                }
                case pvShort: {
                    return new BasePVShort(scalar);
                }
                case pvInt: {
                    return new BasePVInt(scalar);
                }
                case pvLong: {
                    return new BasePVLong(scalar);
                }
                case pvUByte: {
                    return new BasePVUByte(scalar);
                }
                case pvUShort: {
                    return new BasePVUShort(scalar);
                }
                case pvUInt: {
                    return new BasePVUInt(scalar);
                }
                case pvULong: {
                    return new BasePVULong(scalar);
                }
                case pvFloat: {
                    return new BasePVFloat(scalar);
                }
                case pvDouble: {
                    return new BasePVDouble(scalar);
                }
                case pvString: {
                    return new BasePVString(scalar);
                }
            }
            throw new IllegalArgumentException("Illegal Type. Must be pvBoolean,...");
        }

        @Override
        public PVScalar createPVScalar(ScalarType scalarType) {
            Scalar scalar = fieldCreate.createScalar(scalarType);
            return this.createPVScalar(scalar);
        }

        @Override
        public PVScalar createPVScalar(PVScalar scalarToClone) {
            PVScalar pvScalar = this.createPVScalar(scalarToClone.getScalar().getScalarType());
            convert.copyScalar(scalarToClone, pvScalar);
            return pvScalar;
        }

        @Override
        public PVScalarArray createPVScalarArray(ScalarArray array) {
            switch (array.getElementType()) {
                case pvBoolean: {
                    return new BasePVBooleanArray(array);
                }
                case pvByte: {
                    return new BasePVByteArray(array);
                }
                case pvShort: {
                    return new BasePVShortArray(array);
                }
                case pvInt: {
                    return new BasePVIntArray(array);
                }
                case pvLong: {
                    return new BasePVLongArray(array);
                }
                case pvUByte: {
                    return new BasePVUByteArray(array);
                }
                case pvUShort: {
                    return new BasePVUShortArray(array);
                }
                case pvUInt: {
                    return new BasePVUIntArray(array);
                }
                case pvULong: {
                    return new BasePVULongArray(array);
                }
                case pvFloat: {
                    return new BasePVFloatArray(array);
                }
                case pvDouble: {
                    return new BasePVDoubleArray(array);
                }
                case pvString: {
                    return new BasePVStringArray(array);
                }
            }
            throw new IllegalArgumentException("Illegal Type. Logic error");
        }

        @Override
        public PVScalarArray createPVScalarArray(ScalarType scalarType) {
            return this.createPVScalarArray(fieldCreate.createScalarArray(scalarType));
        }

        @Override
        public PVScalarArray createPVScalarArray(PVScalarArray arrayToClone) {
            PVScalarArray pvArray = this.createPVScalarArray(arrayToClone.getScalarArray().getElementType());
            convert.copyScalarArray(arrayToClone, 0, pvArray, 0, arrayToClone.getLength());
            return pvArray;
        }

        @Override
        public PVStructureArray createPVStructureArray(StructureArray structureArray) {
            return new BasePVStructureArray(structureArray);
        }

        @Override
        public PVUnionArray createPVUnionArray(UnionArray unionArray) {
            return new BasePVUnionArray(unionArray);
        }

        @Override
        public PVStructure createPVStructure(Structure structure) {
            return new BasePVStructure(structure);
        }

        @Override
        public PVStructure createPVStructure(String[] fieldNames, PVField[] pvFields) {
            int length = pvFields.length;
            Field[] fields = new Field[length];
            for (int i = 0; i < length; ++i) {
                fields[i] = pvFields[i].getField();
            }
            Structure structure = fieldCreate.createStructure(fieldNames, fields);
            BasePVStructure pvStructure = new BasePVStructure(structure, pvFields);
            return pvStructure;
        }

        @Override
        public PVStructure createPVStructure(PVStructure structToClone) {
            if (structToClone == null) {
                throw new IllegalArgumentException("structToClone is null");
            }
            Structure structure = fieldCreate.createStructure(structToClone.getStructure());
            BasePVStructure pvStructure = new BasePVStructure(structure);
            if (!this.copyStructure(structToClone, pvStructure)) {
                System.err.printf("strictToClone%n%s%n", structToClone);
                System.err.printf("pvStructure%n%s%n", pvStructure);
                System.err.printf("strictToClone structure%n%s%n", structToClone.getStructure());
                System.err.printf("pvStructure structure%n%s%n", pvStructure.getStructure());
                throw new IllegalStateException("structureToClone differs from pvStructure");
            }
            return pvStructure;
        }

        @Override
        public PVUnion createPVUnion(Union union) {
            return new BasePVUnion(union);
        }

        @Override
        public PVUnion createPVVariantUnion() {
            return new BasePVUnion(fieldCreate.createVariantUnion());
        }

        @Override
        public PVUnion createPVUnion(PVUnion unionToClone) {
            if (unionToClone == null) {
                throw new IllegalArgumentException("unionToClone is null");
            }
            BasePVUnion union = new BasePVUnion(unionToClone.getUnion());
            union.set(unionToClone.getSelectedIndex(), this.createPVField(unionToClone.get()));
            return union;
        }

        @Override
        public PVUnionArray createPVVariantUnionArray() {
            return new BasePVUnionArray(fieldCreate.createVariantUnionArray());
        }

        @Override
        public <T extends PVScalar, TA extends PVScalarArray> T createPVScalar(PVScalarType<T, TA> scalarType) {
            return (T)((PVScalar)scalarType.getPVFieldClass().cast(this.createPVScalar(scalarType.getScalarType())));
        }

        @Override
        public <T extends PVScalar, TA extends PVScalarArray> TA createPVScalarArray(PVScalarType<T, TA> elementType) {
            return (TA)((PVScalarArray)elementType.getPVFieldArrayClass().cast(this.createPVScalarArray(elementType.getScalarType())));
        }

        @Override
        public PVStructureArray createPVStructureArray(Structure structure) {
            return this.createPVStructureArray(fieldCreate.createStructureArray(structure));
        }

        @Override
        public PVUnionArray createPVUnionArray(Union union) {
            return this.createPVUnionArray(fieldCreate.createUnionArray(union));
        }

        @Override
        public PVField[] flattenPVStructure(PVStructure pvStructure) {
            Flatten temp = new Flatten(pvStructure);
            temp.initStructure(pvStructure);
            return temp.pvFields;
        }

        private boolean copyStructure(PVStructure from, PVStructure to) {
            PVField[] toFields;
            boolean result = true;
            PVField[] fromFields = from.getPVFields();
            if (fromFields.length != (toFields = to.getPVFields()).length) {
                Formatter formatter = new Formatter();
                formatter.format("PVDataFactory.copyStructure number of fields differ %nfrom %s%nto %s", from.toString(), to.toString());
                String message = formatter.toString();
                System.out.println(message);
                formatter.close();
                return false;
            }
            for (int i = 0; i < fromFields.length; ++i) {
                PVArray toPVArray;
                PVField fromPV = fromFields[i];
                PVField toPV = toFields[i];
                Type type = fromPV.getField().getType();
                if (type == Type.structure) {
                    boolean xxx = this.copyStructure((PVStructure)fromPV, (PVStructure)toPV);
                    if (!result) continue;
                    result = xxx;
                    continue;
                }
                if (type == Type.scalar) {
                    convert.copyScalar((PVScalar)fromPV, (PVScalar)toPV);
                    continue;
                }
                if (type == Type.scalarArray) {
                    PVScalarArray fromPVArray = (PVScalarArray)fromPV;
                    toPVArray = (PVScalarArray)toPV;
                    convert.copyScalarArray(fromPVArray, 0, (PVScalarArray)toPVArray, 0, fromPVArray.getLength());
                    continue;
                }
                PVStructureArray fromPVArray = (PVStructureArray)fromPV;
                toPVArray = (PVStructureArray)toPV;
                convert.copyStructureArray(fromPVArray, (PVStructureArray)toPVArray);
            }
            return result;
        }

        private static class Flatten {
            private PVField[] pvFields = null;
            private int currentIndex = 0;

            private Flatten(PVStructure pvStructure) {
                this.pvFields = new PVField[pvStructure.getNumberFields()];
            }

            private void initStructure(PVStructure pvStructure) {
                PVField[] pvStructureFields;
                this.pvFields[this.currentIndex++] = pvStructure;
                for (PVField pvField : pvStructureFields = pvStructure.getPVFields()) {
                    if (pvField.getField().getType() == Type.structure) {
                        this.initStructure((PVStructure)pvField);
                        continue;
                    }
                    this.pvFields[this.currentIndex++] = pvField;
                }
            }
        }
    }
}

