/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvdata.factory;

import java.nio.ByteBuffer;
import org.epics.pvdata.factory.BaseBoundedString;
import org.epics.pvdata.factory.BaseFieldBuilder;
import org.epics.pvdata.factory.BaseScalar;
import org.epics.pvdata.factory.BaseScalarArray;
import org.epics.pvdata.factory.BaseScalarBoundedArray;
import org.epics.pvdata.factory.BaseScalarFixedArray;
import org.epics.pvdata.factory.BaseStructure;
import org.epics.pvdata.factory.BaseStructureArray;
import org.epics.pvdata.factory.BaseUnion;
import org.epics.pvdata.factory.BaseUnionArray;
import org.epics.pvdata.misc.SerializeHelper;
import org.epics.pvdata.pv.BoundedString;
import org.epics.pvdata.pv.DeserializableControl;
import org.epics.pvdata.pv.Field;
import org.epics.pvdata.pv.FieldBuilder;
import org.epics.pvdata.pv.FieldCreate;
import org.epics.pvdata.pv.Scalar;
import org.epics.pvdata.pv.ScalarArray;
import org.epics.pvdata.pv.ScalarType;
import org.epics.pvdata.pv.Structure;
import org.epics.pvdata.pv.StructureArray;
import org.epics.pvdata.pv.Union;
import org.epics.pvdata.pv.UnionArray;

public final class FieldFactory {
    private static FieldCreateImpl singleImplementation = null;
    private static Scalar[] scalars = null;
    private static ScalarArray[] scalarArrays = null;
    private static Union variantUnion = null;
    private static UnionArray variantUnionArray = null;

    private FieldFactory() {
    }

    public static synchronized FieldCreate getFieldCreate() {
        if (singleImplementation == null) {
            int i;
            singleImplementation = new FieldCreateImpl();
            ScalarType[] scalarTypes = ScalarType.values();
            int num = scalarTypes.length;
            scalars = new Scalar[num];
            for (i = 0; i < num; ++i) {
                FieldFactory.scalars[i] = new BaseScalar(scalarTypes[i]);
            }
            scalarArrays = new ScalarArray[num];
            for (i = 0; i < num; ++i) {
                FieldFactory.scalarArrays[i] = new BaseScalarArray(scalarTypes[i]);
            }
            variantUnion = new BaseUnion();
            variantUnionArray = new BaseUnionArray(variantUnion);
        }
        return singleImplementation;
    }

    private static final class FieldCreateImpl
    implements FieldCreate {
        static final ScalarType[] integerLUT = new ScalarType[]{ScalarType.pvByte, ScalarType.pvShort, ScalarType.pvInt, ScalarType.pvLong, ScalarType.pvUByte, ScalarType.pvUShort, ScalarType.pvUInt, ScalarType.pvULong};
        static final ScalarType[] floatLUT = new ScalarType[]{null, null, ScalarType.pvFloat, ScalarType.pvDouble, null, null, null, null};

        private FieldCreateImpl() {
        }

        @Override
        public FieldBuilder createFieldBuilder() {
            return new BaseFieldBuilder();
        }

        @Override
        public Scalar createScalar(ScalarType scalarType) {
            return scalars[scalarType.ordinal()];
        }

        @Override
        public BoundedString createBoundedString(int maxLength) {
            return new BaseBoundedString(maxLength);
        }

        @Override
        public ScalarArray createScalarArray(ScalarType elementType) {
            return scalarArrays[elementType.ordinal()];
        }

        @Override
        public ScalarArray createFixedScalarArray(ScalarType elementType, int size) {
            return new BaseScalarFixedArray(elementType, size);
        }

        @Override
        public ScalarArray createBoundedScalarArray(ScalarType elementType, int bound) {
            return new BaseScalarBoundedArray(elementType, bound);
        }

        @Override
        public StructureArray createStructureArray(Structure elementStructure) {
            return new BaseStructureArray(elementStructure);
        }

        @Override
        public UnionArray createUnionArray(Union elementUnion) {
            return new BaseUnionArray(elementUnion);
        }

        @Override
        public UnionArray createVariantUnionArray() {
            return variantUnionArray;
        }

        @Override
        public Structure createStructure(String[] fieldNames, Field[] fields) {
            this.validateFieldNames(fieldNames);
            return new BaseStructure(fieldNames, fields);
        }

        @Override
        public Structure createStructure(String id, String[] fieldNames, Field[] fields) {
            this.validateFieldNames(fieldNames);
            return new BaseStructure(id, fieldNames, fields);
        }

        @Override
        public Structure createStructure(Structure structToClone) {
            String[] oldFieldNames = structToClone.getFieldNames();
            Field[] oldFields = structToClone.getFields();
            int n = oldFieldNames.length;
            String[] fieldNames = new String[n];
            Field[] fields = new Field[n];
            for (int i = 0; i < n; ++i) {
                fieldNames[i] = oldFieldNames[i];
                fields[i] = oldFields[i];
            }
            String id = structToClone.getID();
            BaseStructure structure = (BaseStructure)this.createStructure(id, fieldNames, fields);
            structure.clone(fields, fieldNames);
            return structure;
        }

        @Override
        public Structure appendField(Structure structure, String fieldName, Field field) {
            this.validateFieldName(fieldName);
            String[] oldNames = structure.getFieldNames();
            Field[] oldFields = structure.getFields();
            String oldID = structure.getID();
            int oldlen = oldNames.length;
            String[] newNames = new String[oldlen + 1];
            Field[] newFields = new Field[oldlen + 1];
            for (int i = 0; i < oldlen; ++i) {
                newNames[i] = oldNames[i];
                newFields[i] = oldFields[i];
            }
            newNames[oldlen] = fieldName;
            newFields[oldlen] = field;
            return this.createStructure(oldID, newNames, newFields);
        }

        @Override
        public Structure appendFields(Structure structure, String[] fieldNames, Field[] fields) {
            int i;
            this.validateFieldNames(fieldNames);
            String[] oldNames = structure.getFieldNames();
            Field[] oldFields = structure.getFields();
            String oldID = structure.getID();
            int oldlen = oldNames.length;
            int extra = fieldNames.length;
            int newlen = oldlen + fieldNames.length;
            String[] newNames = new String[newlen];
            Field[] newFields = new Field[newlen];
            for (i = 0; i < oldlen; ++i) {
                newNames[i] = oldNames[i];
                newFields[i] = oldFields[i];
            }
            for (i = 0; i < extra; ++i) {
                newNames[i + oldlen] = fieldNames[i];
                newFields[i + oldlen] = fields[i];
            }
            return this.createStructure(oldID, newNames, newFields);
        }

        @Override
        public Union createVariantUnion() {
            return variantUnion;
        }

        @Override
        public Union createUnion(String[] fieldNames, Field[] fields) {
            this.validateFieldNames(fieldNames);
            return new BaseUnion(fieldNames, fields);
        }

        @Override
        public Union createUnion(String id, String[] fieldNames, Field[] fields) {
            this.validateFieldNames(fieldNames);
            return new BaseUnion(id, fieldNames, fields);
        }

        static final ScalarType decodeScalar(byte code) {
            switch (code >> 5) {
                case 0: {
                    return ScalarType.pvBoolean;
                }
                case 1: {
                    return integerLUT[code & 7];
                }
                case 2: {
                    return floatLUT[code & 7];
                }
                case 3: {
                    return ScalarType.pvString;
                }
            }
            return null;
        }

        @Override
        public Field deserialize(ByteBuffer buffer, DeserializableControl control) {
            int size;
            boolean notArray;
            control.ensureData(1);
            byte code = buffer.get();
            if (code == -1) {
                return null;
            }
            int typeCode = code & 0xE7;
            int scalarOrArray = code & 0x18;
            boolean bl = notArray = scalarOrArray == 0;
            if (notArray) {
                if (typeCode < 128) {
                    ScalarType scalarType = FieldCreateImpl.decodeScalar(code);
                    if (scalarType == null) {
                        throw new IllegalArgumentException("invalid scalar type encoding");
                    }
                    return scalars[scalarType.ordinal()];
                }
                if (typeCode == 128) {
                    return BaseStructure.deserializeStructureField(buffer, control);
                }
                if (typeCode == 129) {
                    return BaseUnion.deserializeUnionField(buffer, control);
                }
                if (typeCode == 130) {
                    return variantUnion;
                }
                if (typeCode == 131) {
                    int maxLength = SerializeHelper.readSize(buffer, control);
                    return new BaseBoundedString(maxLength);
                }
                throw new IllegalArgumentException("invalid type encoding");
            }
            boolean isVariable = scalarOrArray == 8;
            boolean isFixed = scalarOrArray == 24;
            int n = size = isVariable ? 0 : SerializeHelper.readSize(buffer, control);
            if (typeCode < 128) {
                ScalarType scalarType = FieldCreateImpl.decodeScalar(code);
                if (scalarType == null) {
                    throw new IllegalArgumentException("invalid scalarArray type encoding");
                }
                if (isVariable) {
                    return scalarArrays[scalarType.ordinal()];
                }
                if (isFixed) {
                    return new BaseScalarFixedArray(scalarType, size);
                }
                return new BaseScalarBoundedArray(scalarType, size);
            }
            if (typeCode == 128) {
                if (!isVariable) {
                    throw new IllegalArgumentException("fixed and bounded structure array not supported");
                }
                Structure elementStructure = (Structure)control.cachedDeserialize(buffer);
                return new BaseStructureArray(elementStructure);
            }
            if (typeCode == 129) {
                if (!isVariable) {
                    throw new IllegalArgumentException("fixed and bounded union array not supported");
                }
                Union elementUnion = (Union)control.cachedDeserialize(buffer);
                return new BaseUnionArray(elementUnion);
            }
            if (typeCode == 130) {
                if (!isVariable) {
                    throw new IllegalArgumentException("fixed and bounded union array not supported");
                }
                return variantUnionArray;
            }
            throw new IllegalArgumentException("invalid type encoding");
        }

        private void validateFieldNames(String[] names) {
            for (String name : names) {
                this.validateFieldName(name);
            }
        }

        private void validateFieldName(String name) {
            if (!name.matches("[_a-zA-Z][_a-zA-Z0-9]*")) {
                throw new IllegalArgumentException("Invalid field name '" + name + "'");
            }
        }
    }
}

